/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.Introspectable;
import org.freedesktop.dbus.interfaces.Peer;
import org.freedesktop.dbus.test.helper.cross.CrossTestClient;
import org.freedesktop.dbus.test.helper.cross.CrossTestServer;
import org.freedesktop.dbus.test.helper.interfaces.Binding;
import org.freedesktop.dbus.test.helper.interfaces.SamplesInterface;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestCross {
    private ServerThread serverThread;
    private volatile boolean serverReady = false;

    @BeforeEach
    public void before() {
        this.serverThread = new ServerThread();
        this.serverThread.setName("Server Thread");
        this.serverThread.start();
    }

    @AfterEach
    public void after() {
        if (this.serverThread != null) {
            this.serverThread.interrupt();
        }
    }

    @Test
    public void testCross() throws InterruptedException {
        while (!this.serverReady) {
            Thread.sleep(500L);
        }
        try (DBusConnection conn = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);){
            CrossTestClient client = new CrossTestClient(conn);
            conn.exportObject("/TestClient", (DBusInterface)client);
            conn.addSigHandler(Binding.SampleSignals.Triggered.class, (DBusSigHandler)client);
            SamplesInterface tests = (SamplesInterface)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", SamplesInterface.class);
            Binding.SingleSample singletests = (Binding.SingleSample)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", Binding.SingleSample.class);
            Peer peer = (Peer)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", Peer.class);
            Introspectable intro = (Introspectable)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/Test", Introspectable.class);
            Introspectable rootintro = (Introspectable)conn.getRemoteObject("org.freedesktop.DBus.Binding.TestServer", "/", Introspectable.class);
            client.doTests(peer, intro, rootintro, tests, singletests);
            for (String string : client.getPassed()) {
                System.out.println(string + " pass");
            }
            for (Map.Entry entry : client.getFailed().entrySet()) {
                for (String msg : (List)entry.getValue()) {
                    System.out.println((String)entry.getKey() + " failed: " + msg);
                }
            }
        }
        catch (IOException | DBusException exDbe) {
            exDbe.printStackTrace();
            Assertions.fail((String)"Exception while processing DBus");
        }
    }

    private class ServerThread
    extends Thread {
        private CrossTestServer cts;

        private ServerThread() {
        }

        @Override
        public void run() {
            try (DBusConnection conn = DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);){
                conn.requestBusName("org.freedesktop.DBus.Binding.TestServer");
                this.cts = new CrossTestServer(conn);
                conn.addSigHandler(Binding.SampleClient.Trigger.class, (DBusSigHandler)this.cts);
                conn.exportObject("/Test", (DBusInterface)this.cts);
                TestCross.this.serverReady = true;
                while (this.cts.isRun()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                for (String s : this.cts.getDone()) {
                    System.out.println(s + " ok");
                }
                for (String s : this.cts.getNotdone()) {
                    System.out.println("---> " + s + " untested");
                }
                conn.disconnect();
                Assertions.assertTrue((boolean)this.cts.getNotdone().isEmpty(), (String)("All tests should have been run, following failed: " + String.join((CharSequence)", ", this.cts.getNotdone())));
            }
            catch (IOException | DBusException exDe) {
                exDe.printStackTrace();
                Assertions.fail((String)"Exception while server running");
            }
        }
    }
}

