/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.lang.reflect.Method;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;
import org.freedesktop.dbus.annotations.DeprecatedOnDBus;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.utils.DBusNamingUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DBusNamingUtilTest {
    DBusNamingUtilTest() {
    }

    @Test
    void getInterfaceNameTest() {
        Assertions.assertEquals((Object)"org.freedesktop.dbus.utils.DBusNamingUtilTest.Foo", (Object)DBusNamingUtil.getInterfaceName(Foo.class));
        Assertions.assertEquals((Object)"com.example.Bar", (Object)DBusNamingUtil.getInterfaceName(Bar.class));
    }

    @Test
    void getMethodNameTest() throws NoSuchMethodException {
        Method method1 = InterfaceWithMethodsAndSignals.class.getMethod("method1", new Class[0]);
        Assertions.assertEquals((Object)"method1", (Object)DBusNamingUtil.getMethodName((Method)method1));
        Method method2 = InterfaceWithMethodsAndSignals.class.getMethod("method2", new Class[0]);
        Assertions.assertEquals((Object)"methodAnnotationName", (Object)DBusNamingUtil.getMethodName((Method)method2));
    }

    @Test
    void getSignalNameTest() {
        Class<InterfaceWithMethodsAndSignals.Signal1> signal1 = InterfaceWithMethodsAndSignals.Signal1.class;
        Assertions.assertEquals((Object)"Signal1", (Object)DBusNamingUtil.getSignalName(signal1));
        Class<InterfaceWithMethodsAndSignals.Signal2> signal2 = InterfaceWithMethodsAndSignals.Signal2.class;
        Assertions.assertEquals((Object)"SignalAnnotationName", (Object)DBusNamingUtil.getSignalName(signal2));
    }

    @Test
    void getAnnotationNameTest() {
        Assertions.assertEquals((Object)"org.freedesktop.DBus.Deprecated", (Object)DBusNamingUtil.getAnnotationName(DeprecatedOnDBus.class));
    }

    public static interface InterfaceWithMethodsAndSignals
    extends DBusInterface {
        public void method1();

        @DBusMemberName(value="methodAnnotationName")
        public void method2();

        @DBusMemberName(value="SignalAnnotationName")
        public static class Signal2
        extends DBusSignal {
            public Signal2(String objectPath, Object ... args) throws DBusException {
                super(objectPath, args);
            }
        }

        public static class Signal1
        extends DBusSignal {
            public Signal1(String objectPath, Object ... args) throws DBusException {
                super(objectPath, args);
            }
        }
    }

    @DBusInterfaceName(value="com.example.Bar")
    static interface Bar
    extends DBusInterface {
    }

    static interface Foo
    extends DBusInterface {
    }
}

