/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test;

import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;
import org.freedesktop.dbus.bin.EmbeddedDBusDaemon;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DirectConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.test.AbstractBaseTest;
import org.junit.jupiter.api.Test;

public class SignalNameTest
extends AbstractBaseTest {
    @Test
    public void testSignalNameAlias() throws Exception {
        String createDynamicTCPSession = DirectConnection.createDynamicTCPSession();
        try (EmbeddedDBusDaemon daemon = new EmbeddedDBusDaemon();){
            daemon.setAddress(createDynamicTCPSession);
            daemon.startInBackground();
            this.logger.debug("Started embedded bus on address {}", (Object)createDynamicTCPSession);
            Thread.sleep(2000L);
            try (DBusConnection connection = DBusConnection.getConnection((String)createDynamicTCPSession, (boolean)true, (boolean)true, (int)10000);){
                connection.requestBusName("d.e.f.Service");
                connection.exportObject("/d/e/f/custom", (DBusInterface)new MyCustomImpl());
                connection.addSigHandler(CustomService.CustomSignal.class, (DBusSigHandler)new DBusSigHandler<CustomService.CustomSignal>(){

                    public void handle(CustomService.CustomSignal s) {
                        System.out.printf("Received signal: %s%n", s.data);
                    }
                });
                connection.sendMessage((Message)new CustomService.CustomSignal("/a/b/c/custom", "hello world"));
                Thread.sleep(1000L);
            }
        }
    }

    public static class MyCustomImpl
    implements CustomService {
        @Override
        public void nothing() {
            System.out.println("Just doing nothing");
        }

        public String getObjectPath() {
            return "/d/e/f/custom";
        }
    }

    @DBusInterfaceName(value="d.e.f.Custom")
    public static interface CustomService
    extends DBusInterface {
        public void nothing();

        @DBusMemberName(value="custom_signal")
        public static class CustomSignal
        extends DBusSignal {
            public final String data;

            public CustomSignal(String path, String data) throws DBusException {
                super(path, new Object[]{data});
                this.data = data;
            }
        }
    }
}

