/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.test.collections.empty.structs;

import org.freedesktop.dbus.Struct;
import org.freedesktop.dbus.annotations.Position;
import org.freedesktop.dbus.test.collections.empty.structs.IEmptyCollectionStruct;
import org.freedesktop.dbus.test.helper.structs.IntStruct;

public final class DeepArrayStruct
extends Struct
implements IEmptyCollectionStruct<IntStruct[][][]> {
    @Position(value=0)
    private final IntStruct[][][] list;
    @Position(value=1)
    private final String validationValue;

    public DeepArrayStruct(IntStruct[][][] list, String validationValue) {
        this.list = (IntStruct[][][])list.clone();
        this.validationValue = validationValue;
    }

    @Override
    public IntStruct[][][] getValue() {
        return (IntStruct[][][])this.list.clone();
    }

    @Override
    public String getValidationValue() {
        return this.validationValue;
    }

    @Override
    public String getStringTestValue() {
        String string = "[";
        for (IntStruct[][] l1 : this.list) {
            string = string + "[";
            for (IntStruct[] l2 : l1) {
                string = string + "[";
                for (IntStruct e : l2) {
                    string = string + e.toSimpleString();
                }
                string = string + "]";
            }
            string = string + "]";
        }
        string = string + "]";
        return string;
    }

    @Override
    public boolean isEmpty() {
        return this.list.length == 0;
    }
}

