/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh;

import com.github.hypfvieh.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public abstract class AbstractBaseUtilTest
extends Assert {
    @Rule
    public TestName testName = new TestName();
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            System.out.println("  [TEST]: " + description.getMethodName());
        }
    };

    private static String getStackTraceString(int _index) {
        StackTraceElement[] arrStackTraceElems = new Throwable().fillInStackTrace().getStackTrace();
        int lIndex = Math.min(arrStackTraceElems.length - 1, Math.max(0, _index));
        return arrStackTraceElems[lIndex].getClassName() + "." + arrStackTraceElems[lIndex].getMethodName();
    }

    public static String getMethodName() {
        return AbstractBaseUtilTest.getStackTraceString(2);
    }

    public static String getCallingMethodName() {
        return AbstractBaseUtilTest.getStackTraceString(3);
    }

    private static String getExceptionAsString(Throwable _ex) {
        if (_ex == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (_ex.getStackTrace() == null) {
            _ex.fillInStackTrace();
        }
        _ex.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    public static void assertNotEquals(Object _obj1, Object _obj2) {
        Assert.assertFalse((String)("Parameters are equal: " + _obj1 + " = " + _obj2), (boolean)Objects.equals(_obj1, _obj2));
    }

    public static void assertEmpty(String _string) {
        Assert.assertTrue((String)"String not empty.", (boolean)(_string != null ? _string.isEmpty() : false));
    }

    public static void assertNotEmpty(String _string) {
        Assert.assertTrue((String)"String is empty.", (boolean)(_string != null ? _string.isEmpty() : true));
    }

    public static void assertBlank(String _string) {
        Assert.assertTrue((String)"String not blank.", (boolean)StringUtil.isBlank((String)_string));
    }

    public static void assertNotBlank(String _string) {
        Assert.assertTrue((String)"String is blank.", (!StringUtil.isBlank((String)_string) ? 1 : 0) != 0);
    }

    public static void assertContains(String _string, String _contains) {
        if (_contains != null) {
            Assert.assertTrue((String)("String does not contain [" + _contains + "]: " + _string), (boolean)(_string != null ? _string.contains(_contains) : false));
        }
    }

    public static void assertContainsNot(String _string, String _notContains) {
        if (_notContains != null) {
            Assert.assertFalse((String)("String contains [" + _notContains + "]: " + _string), (boolean)(_string != null ? _string.contains(_notContains) : true));
        }
    }

    public static void assertDoubleEquals(double _expected, double _actual) {
        AbstractBaseUtilTest.assertEquals((double)_expected, (double)_actual, (double)1.0E-6);
    }

    public static void assertFail(String _message, Throwable _ex) {
        String message = StringUtil.defaultIfBlank((String)_message, (String)("!no fail message provided by " + AbstractBaseUtilTest.getCallingMethodName()));
        if (_ex != null) {
            message = message + " " + AbstractBaseUtilTest.getExceptionAsString(_ex);
        }
        Assert.fail((String)message);
    }

    public static void assertFail(String _message) {
        AbstractBaseUtilTest.assertFail(_message, null);
    }

    public static final File assertFileExists(File _file) {
        return AbstractBaseUtilTest.assertFileExists(_file, true);
    }

    public static final File assertFileNotExists(File _file) {
        return AbstractBaseUtilTest.assertFileExists(_file, false);
    }

    private static File assertFileExists(File _file, boolean _exists) {
        AbstractBaseUtilTest.assertNotNull((String)"File object is null.", (Object)_file);
        if (_exists) {
            AbstractBaseUtilTest.assertTrue((String)("File [" + _file.getAbsolutePath() + "] does not exist."), (boolean)_file.exists());
        } else {
            AbstractBaseUtilTest.assertTrue((String)("File [" + _file.getAbsolutePath() + "] exists."), (!_file.exists() ? 1 : 0) != 0);
        }
        return _file;
    }

    public static final File assertFileExists(String _file) {
        AbstractBaseUtilTest.assertNotNull((Object)_file);
        return AbstractBaseUtilTest.assertFileExists(new File(_file));
    }

    public static final String assertEnvSet(String _name) {
        AbstractBaseUtilTest.assertNotNull((Object)_name);
        String value = System.getenv(_name);
        AbstractBaseUtilTest.assertNotEmpty(value);
        return value;
    }

    @SafeVarargs
    public static final <K, V> Map<K, V> assertMap(Map<K, V> _map, K ... _keys) {
        AbstractBaseUtilTest.assertNotNull((String)"Map is null.", _map);
        if (_keys != null) {
            for (K key : _keys) {
                AbstractBaseUtilTest.assertTrue((String)("Key [" + key + "] not found in map: " + _map), (boolean)_map.containsKey(key));
            }
        }
        return _map;
    }

    @SafeVarargs
    public static final <V> Collection<V> assertCollection(Collection<V> _coll, V ... _values) {
        AbstractBaseUtilTest.assertNotNull((String)"Collection is null.", _coll);
        ArrayList<V> notFound = new ArrayList<V>();
        if (_values != null) {
            for (V val : _values) {
                if (_coll.contains(val)) continue;
                notFound.add(val);
            }
        }
        AbstractBaseUtilTest.assertTrue((String)("Values " + notFound + " not found in collection: " + _coll), (notFound.size() == 0 ? 1 : 0) != 0);
        return _coll;
    }

    public static void assertInstanceOf(Object _obj, Class<?> _class) {
        AbstractBaseUtilTest.assertTrue((String)(_obj + " is not an instance of " + _class + "."), (_obj != null && _class != null && _class.isAssignableFrom(_obj.getClass()) ? 1 : 0) != 0);
    }

    public static final void assertPatternFind(String _str, String _pattern) {
        AbstractBaseUtilTest.assertNotNull((String)"String may not be null.", (Object)_str);
        AbstractBaseUtilTest.assertNotNull((String)"Pattern may not be null.", (Object)_pattern);
        AbstractBaseUtilTest.assertTrue((String)("Pattern [" + _pattern + "] not found in string [" + _str + "]."), (boolean)Pattern.compile(_pattern).matcher(_str).find());
    }

    public static final void assertPatternMatches(String _str, String _pattern) {
        AbstractBaseUtilTest.assertNotNull((String)"String may not be null.", (Object)_str);
        AbstractBaseUtilTest.assertNotNull((String)"Pattern may not be null.", (Object)_pattern);
        AbstractBaseUtilTest.assertTrue((String)("Pattern [" + _pattern + "] does not match string [" + _str + "]."), (boolean)Pattern.compile(_pattern).matcher(_str).matches());
    }
}

