/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.util.TimeMeasure;
import org.junit.Assert;
import org.junit.Test;

public class TimeMeasureTest
extends AbstractBaseUtilTest {
    @Test
    public void testTimeMeasure() {
        TimeMeasure tm = new TimeMeasure();
        Assert.assertTrue((tm.getElapsed() >= 0L ? 1 : 0) != 0);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException _ex) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertTrue((tm.getElapsed() >= 100L ? 1 : 0) != 0);
        Assert.assertTrue((String)("toString() returned " + tm), (boolean)tm.toString().matches("^[0-9]+ms$"));
        tm.reset();
        long elapsed = tm.getElapsed();
        Assert.assertTrue((elapsed < 10L ? 1 : 0) != 0);
        tm.startTm = tm.getStartTime() - 10000L;
        elapsed = tm.getElapsed();
        Assert.assertTrue((String)("Elapsed was " + elapsed), (elapsed >= 10000L ? 1 : 0) != 0);
        Assert.assertTrue((String)("toString() returned " + tm), (boolean)tm.toString().matches("^[0-9]+\\.[0-9]s$"));
    }

    @Test
    public void testTimeMeasureFormatter() {
        TimeMeasure tm = new TimeMeasure();
        String oneSecond = tm.getElapsedFormatted(null, 1000L);
        TimeMeasureTest.assertEquals((Object)"00:00:01.000", (Object)oneSecond);
        String oneMinuteoneSecond = tm.getElapsedFormatted(null, 61000L);
        TimeMeasureTest.assertEquals((Object)"00:01:01.000", (Object)oneMinuteoneSecond);
        String threeSecondsAfewMillis = tm.getElapsedFormatted(null, 3721L);
        TimeMeasureTest.assertEquals((Object)"00:00:03.721", (Object)threeSecondsAfewMillis);
    }
}

