/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.system;

import com.github.hypfvieh.common.SearchOrder;
import com.github.hypfvieh.util.SystemUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public final class NativeLibraryLoader {
    private static final NativeLibraryLoader INSTANCE = new NativeLibraryLoader();
    private boolean enabled = true;

    private NativeLibraryLoader() {
    }

    public static boolean isEnabled() {
        return NativeLibraryLoader.INSTANCE.enabled;
    }

    public static void setEnabled(boolean _enabled) {
        NativeLibraryLoader.INSTANCE.enabled = _enabled;
    }

    public static void loadLibrary(boolean _trySystemLibsFirst, String _libName, String ... _searchPathes) {
        if (!NativeLibraryLoader.isEnabled()) {
            return;
        }
        ArrayList<SearchOrder> loadOrder = new ArrayList<SearchOrder>();
        if (_trySystemLibsFirst) {
            loadOrder.add(SearchOrder.SYSTEM_PATH);
        }
        loadOrder.add(SearchOrder.CUSTOM_PATH);
        loadOrder.add(SearchOrder.CLASS_PATH);
        NativeLibraryLoader.loadLibrary(_libName, loadOrder.toArray(new SearchOrder[0]), _searchPathes);
    }

    public static void loadLibrary(String _libName, SearchOrder[] _loadOrder, String ... _searchPathes) {
        if (!NativeLibraryLoader.isEnabled()) {
            return;
        }
        for (SearchOrder order : _loadOrder) {
            if (INSTANCE.findProperNativeLib(order, _libName, _searchPathes) != null) continue;
            return;
        }
        throw new RuntimeException("Could not load library from any given source: " + Arrays.toString((Object[])_loadOrder));
    }

    private Throwable findProperNativeLib(SearchOrder _order, String _libName, String[] _searchPathes) {
        String arch = System.getProperty("os.arch");
        Throwable lastErr = null;
        if (_order == SearchOrder.SYSTEM_PATH) {
            Throwable loadError = this.loadSystemLib(_libName);
            if (loadError == null) {
                return null;
            }
        } else if (_order == SearchOrder.CLASS_PATH) {
            for (String path : _searchPathes) {
                InputStream libAsStream;
                String fileNameWithPath = SystemUtil.concatFilePath(false, path, arch, _libName);
                lastErr = this.loadFromStream(fileNameWithPath, libAsStream = NativeLibraryLoader.class.getClassLoader().getResourceAsStream(fileNameWithPath));
                if (lastErr == null) {
                    return null;
                }
                fileNameWithPath = SystemUtil.concatFilePath(false, path, _libName);
                lastErr = this.loadFromStream(fileNameWithPath, libAsStream = NativeLibraryLoader.class.getClassLoader().getResourceAsStream(fileNameWithPath));
                if (lastErr != null) continue;
                return null;
            }
        } else {
            for (String path : _searchPathes) {
                File file = new File(SystemUtil.concatFilePath(false, path, arch, _libName));
                if (!file.exists() || (lastErr = this.loadLib(file.getAbsolutePath())) != null) continue;
                return null;
            }
        }
        return lastErr;
    }

    private Throwable loadFromStream(String _fileNameWithPath, InputStream _libAsStream) {
        String fileExt = NativeLibraryLoader.getFileExtension(_fileNameWithPath);
        String prefix = _fileNameWithPath.replace(new File(_fileNameWithPath).getParent(), "").replace("." + fileExt, "");
        try {
            File tmpFile = this.extractToTemp(_libAsStream, prefix, fileExt);
            Throwable loadLibErr = this.loadLib(tmpFile.getAbsolutePath());
            if (loadLibErr != null) {
                return loadLibErr;
            }
        }
        catch (Exception _ex) {
            return _ex;
        }
        return null;
    }

    private Throwable loadLib(String _lib) {
        try {
            System.load(_lib);
            return null;
        }
        catch (Throwable _ex) {
            return _ex;
        }
    }

    private Throwable loadSystemLib(String _libName) {
        ArrayList<String> possibleNames = new ArrayList<String>();
        String fileExtension = NativeLibraryLoader.getFileExtension(_libName);
        String fileWithoutExt = null;
        if (fileExtension != null && !fileExtension.isEmpty()) {
            fileWithoutExt = _libName.replace("." + fileExtension, "");
            possibleNames.add(_libName.replace("." + fileExtension, ""));
        }
        if (_libName.startsWith("lib")) {
            if (fileWithoutExt != null) {
                possibleNames.add(fileWithoutExt.replaceFirst("^lib", ""));
            }
            possibleNames.add(_libName.replaceFirst("^lib", ""));
        }
        Throwable lastError = null;
        for (String name : possibleNames) {
            try {
                System.loadLibrary(name);
                return null;
            }
            catch (Throwable _ex) {
                lastError = _ex;
            }
        }
        return lastError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractToTemp(InputStream _fileToExtract, String _tmpName, String _fileSuffix) throws IOException {
        if (_fileToExtract == null) {
            throw new IOException("Null stream");
        }
        File tempFile = File.createTempFile(_tmpName, _fileSuffix);
        tempFile.deleteOnExit();
        if (!tempFile.exists()) {
            throw new FileNotFoundException("File " + tempFile.getAbsolutePath() + " could not be created");
        }
        byte[] buffer = new byte[1024];
        FileOutputStream os = new FileOutputStream(tempFile);
        try {
            int readBytes;
            while ((readBytes = _fileToExtract.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            _fileToExtract.close();
        }
        return tempFile;
    }

    public static String getFileExtension(String _fileName) {
        if (_fileName == null) {
            return null;
        }
        int lastDot = _fileName.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return _fileName.substring(lastDot + 1);
    }
}

