/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeMeasure {
    volatile long startTm;

    public TimeMeasure() {
        this.reset();
    }

    public final TimeMeasure reset() {
        this.startTm = System.currentTimeMillis();
        return this;
    }

    public long getStartTime() {
        return this.startTm;
    }

    public long getElapsed() {
        return System.currentTimeMillis() - this.startTm;
    }

    public String getElapsedFormatted(DateFormat _dateFormat) {
        return this.getElapsedFormatted(_dateFormat, this.getElapsed());
    }

    String getElapsedFormatted(DateFormat _dateFormat, long _elapsedTime) {
        Date elapsedTime = new Date(_elapsedTime);
        DateFormat sdf = _dateFormat;
        if (_dateFormat == null) {
            sdf = new SimpleDateFormat("HH:mm:ss.SSS");
        }
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(elapsedTime);
    }

    public long getElapsedAndReset() {
        long elapsed = this.getElapsed();
        this.reset();
        return elapsed;
    }

    public String toString() {
        long elapsed = this.getElapsed();
        return elapsed >= 5000L ? (double)((long)((double)elapsed / 1000.0 * 10.0)) / 10.0 + "s" : elapsed + "ms";
    }
}

