/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.ConverterUtil;
import com.github.hypfvieh.util.StringUtil;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class TypeUtil {
    private TypeUtil() {
    }

    @Deprecated
    public static boolean strToBool(String _str) {
        return ConverterUtil.strToBool(_str);
    }

    public static boolean isDouble(String _str) {
        return TypeUtil.isDouble(_str, true);
    }

    public static boolean isDouble(String _str, char _separator) {
        return TypeUtil.isDouble(_str, _separator, true);
    }

    public static boolean isDouble(String _str, boolean _allowNegative) {
        return TypeUtil.isDouble(_str, DecimalFormatSymbols.getInstance().getDecimalSeparator(), _allowNegative);
    }

    public static boolean isDouble(String _str, char _separator, boolean _allowNegative) {
        String pattern = "\\d+XXX\\d+$";
        pattern = _separator == '.' ? pattern.replace("XXX", "\\.?") : pattern.replace("XXX", _separator + "?");
        pattern = _allowNegative ? "^-?" + pattern : "^" + pattern;
        if (_str != null) {
            return _str.matches(pattern) || TypeUtil.isInteger(_str, _allowNegative);
        }
        return false;
    }

    public static boolean isInteger(String _str) {
        return TypeUtil.isInteger(_str, true);
    }

    public static boolean isInteger(String _str, boolean _allowNegative) {
        if (_str == null) {
            return false;
        }
        String regex = "[0-9]+$";
        regex = _allowNegative ? "^-?" + regex : "^" + regex;
        return _str.matches(regex);
    }

    public static boolean isValidNetworkPort(int _port, boolean _allowWellKnown) {
        if (_allowWellKnown) {
            return _port > 0 && _port < 65536;
        }
        return _port > 1024 && _port < 65536;
    }

    public static boolean isValidNetworkPort(String _str, boolean _allowWellKnown) {
        if (TypeUtil.isInteger(_str, false)) {
            return TypeUtil.isValidNetworkPort(Integer.parseInt(_str), _allowWellKnown);
        }
        return false;
    }

    public static boolean isValidRegex(String _regExStr) {
        return TypeUtil.createRegExPatternIfValid(_regExStr) != null;
    }

    public static Pattern createRegExPatternIfValid(String _regExStr) {
        Pattern pattern;
        if (StringUtil.isBlank(_regExStr)) {
            return null;
        }
        try {
            pattern = Pattern.compile(_regExStr);
        }
        catch (PatternSyntaxException _ex) {
            return null;
        }
        return pattern;
    }

    @SafeVarargs
    public static <T> List<T> createList(T ... _entries) {
        ArrayList<T> l = new ArrayList<T>();
        if (_entries != null) {
            l.addAll(Arrays.asList(_entries));
        }
        return l;
    }

    @SafeVarargs
    public static <T> Map<T, T> createMap(T ... _args) {
        HashMap<T, T> map = new HashMap<T, T>();
        if (_args != null) {
            if (_args.length % 2 != 0) {
                throw new IllegalArgumentException("Even number of parameters required to create map: " + Arrays.toString(_args));
            }
            for (int i = 0; i < _args.length; i += 2) {
                map.put(_args[i], _args[i + 1]);
            }
        }
        return map;
    }

    public static boolean isAnyNull(Object ... _objects) {
        if (_objects == null) {
            return true;
        }
        for (Object obj : _objects) {
            if (obj != null) continue;
            return true;
        }
        return false;
    }

    public static void throwIfAnyNull(String _errMsg, Object ... _objects) {
        if (TypeUtil.isAnyNull(_objects)) {
            throw new NullPointerException(_errMsg);
        }
    }

    public static boolean equalsOne(Object _obj, Object ... _arrObj) {
        if (_obj == null || _arrObj == null) {
            return false;
        }
        for (Object o : _arrObj) {
            if (o == null || !_obj.equals(o)) continue;
            return true;
        }
        return false;
    }

    public static <K, V> List<Map<K, V>> splitMap(Map<K, V> _map, int _nbElements) throws InstantiationException, IllegalAccessException {
        ArrayList<Map<K, V>> lofm = new ArrayList<Map<K, V>>();
        lofm.add((Map)_map.getClass().newInstance());
        for (Map.Entry<K, V> e : _map.entrySet()) {
            Map lastSubMap = (Map)lofm.get(lofm.size() - 1);
            if (lastSubMap.size() == _nbElements) {
                lofm.add((Map)_map.getClass().newInstance());
                lastSubMap = (Map)lofm.get(lofm.size() - 1);
            }
            lastSubMap.put(e.getKey(), e.getValue());
        }
        return lofm;
    }

    public static <T> List<List<T>> splitList(List<T> _list, int _elements) {
        ArrayList<List<T>> partitions = new ArrayList<List<T>>();
        for (int i = 0; i < _list.size(); i += _elements) {
            partitions.add(_list.subList(i, Math.min(i + _elements, _list.size())));
        }
        return partitions;
    }

    public static Properties createProperties(String ... _keysAndVals) {
        if (_keysAndVals != null && _keysAndVals.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of String parameters required.");
        }
        Properties props = new Properties();
        if (_keysAndVals != null) {
            for (int i = 0; i < _keysAndVals.length; i += 2) {
                props.setProperty(_keysAndVals[i], _keysAndVals[i + 1]);
            }
        }
        return props;
    }

    public static int defaultIfNotInteger(String _possibleInt, int _default) {
        if (TypeUtil.isInteger(_possibleInt)) {
            return Integer.parseInt(_possibleInt);
        }
        return _default;
    }
}

