/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.util.StringUtil;
import java.util.List;
import org.junit.Test;

public class StringUtilTest
extends AbstractBaseUtilTest {
    @Test
    public void testSmartSplit() throws Exception {
        String sampleText = "Vorbereitung Quoteverbreiterung falls TG nicht da: Felder EE und DU als TG Indikator eingef\u00fcgt. Schalter 16 eingef\u00fcgt. Felder EK und EL eingef\u00fcgt. EK/EL berechnet die MinPerformance Bid/Ask, falls TG nicht als Konkurrenz und Schalter16 auf yes. In RicBid/Ask Formeln so angepasst, dass falls TG nicht Konkurrenz, Schalter16 an und EK/EL > 0, so wird EK/EL 'Smart Performance' verwendet.";
        List smartStringSplit = StringUtil.smartWordSplit((String)sampleText, (int)50);
        StringUtilTest.assertEquals((String)"Expected 8 lines", (long)8L, (long)smartStringSplit.size());
        for (String line : smartStringSplit) {
            StringUtilTest.assertTrue((String)"Each line should be no longer than 50", (line.length() <= 50 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSmartSplitWrongTokenLengthFix() throws Exception {
        String sampleText = "Disconnect the given session. If --force is used socket will be closed without sending logout message";
        List smartStringSplit = StringUtil.smartWordSplit((String)sampleText, (int)29);
        StringUtilTest.assertEquals((String)"Expected 4 lines", (long)4L, (long)smartStringSplit.size());
        for (String line : smartStringSplit) {
            StringUtilTest.assertTrue((String)"Each line should be no longer than 29", (line.length() <= 29 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLowerCaseFirstChar() throws Exception {
        String tstStr = "TEST";
        StringUtilTest.assertEquals((Object)"tEST", (Object)StringUtil.lowerCaseFirstChar((String)tstStr));
    }

    @Test
    public void testUpperCaseFirstChar() throws Exception {
        String tstStr = "test";
        StringUtilTest.assertEquals((Object)"Test", (Object)StringUtil.upperCaseFirstChar((String)tstStr));
    }

    @Test
    public void testJoin() throws Exception {
        String[] toJoin = new String[]{"This", "should", "be", "joined"};
        String joined = StringUtil.join((String)" ", (String[])toJoin);
        StringUtilTest.assertEquals((Object)"This should be joined", (Object)joined);
    }

    @Test
    public void testAbbreviate() throws Exception {
        String tstStr = "This should be shortend";
        StringUtilTest.assertEquals((Object)"This should...", (Object)StringUtil.abbreviate((String)tstStr, (int)14));
    }

    @Test
    public void testConvertCamelToUpperCase() {
        StringUtilTest.assertNull((Object)StringUtil.convertCamelToUpperCase(null));
        StringUtilTest.assertEquals((Object)"", (Object)StringUtil.convertCamelToUpperCase((String)""));
        StringUtilTest.assertEquals((Object)"  ", (Object)StringUtil.convertCamelToUpperCase((String)"  "));
        StringUtilTest.assertEquals((Object)"QUOTE_STATUS_REPORT", (Object)StringUtil.convertCamelToUpperCase((String)"QuoteStatusReport"));
        StringUtilTest.assertEquals((Object)"HELLO", (Object)StringUtil.convertCamelToUpperCase((String)"hello"));
        StringUtilTest.assertEquals((Object)"MEDIA", (Object)StringUtil.convertCamelToUpperCase((String)"MEDIA"));
        StringUtilTest.assertEquals((Object)"ACME_COMPANY", (Object)StringUtil.convertCamelToUpperCase((String)"AcmeCompany"));
    }

    @Test
    public void testConvertUpperToCamelCase() {
        StringUtilTest.assertNull((Object)StringUtil.convertUpperToCamelCase(null));
        StringUtilTest.assertEquals((Object)"", (Object)StringUtil.convertUpperToCamelCase((String)""));
        StringUtilTest.assertEquals((Object)"  ", (Object)StringUtil.convertUpperToCamelCase((String)"  "));
        StringUtilTest.assertEquals((Object)"QuoteStatusReport", (Object)StringUtil.convertUpperToCamelCase((String)"QUOTE_STATUS_REPORT"));
        StringUtilTest.assertEquals((Object)"Hello", (Object)StringUtil.convertUpperToCamelCase((String)"hello"));
        StringUtilTest.assertEquals((Object)"UserResponse", (Object)StringUtil.convertUpperToCamelCase((String)"UserResponse"));
    }
}

