/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.util.SystemUtil;
import java.io.File;
import org.junit.Test;

public class SystemUtilTest
extends AbstractBaseUtilTest {
    @Test
    public void testGetWorkingDirectory() {
        String result = SystemUtil.getWorkingDirectory();
        SystemUtilTest.assertNotNull((Object)result);
    }

    @Test
    public void testConcatFilePath() {
        String result = SystemUtil.concatFilePath((String[])new String[]{"foo", "bar", "baz"});
        SystemUtilTest.assertNotNull((Object)result);
        SystemUtilTest.assertEquals((Object)("foo" + File.separator + "bar" + File.separator + "baz"), (Object)result);
    }

    @Test
    public void testGetTempDir() {
        String tempDir = SystemUtil.getTempDir();
        SystemUtilTest.assertNotNull((Object)tempDir);
        SystemUtilTest.assertTrue((String)("tmpdir " + tempDir + " does not end with file separator"), (boolean)tempDir.endsWith(System.getProperty("file.separator")));
        SystemUtilTest.assertTrue((String)("tmpdir " + tempDir + " does not exist"), (boolean)new File(tempDir).exists());
        SystemUtilTest.assertTrue((String)("tmpdir " + tempDir + " not a directory"), (boolean)new File(tempDir).isDirectory());
        SystemUtilTest.assertEquals((Object)new File(tempDir), (Object)new File(System.getProperty("java.io.tmpdir")));
    }

    @Test
    public void testNormalizePath() {
        SystemUtilTest.assertTrue((SystemUtil.normalizePath(null) == null ? 1 : 0) != 0);
        SystemUtilTest.assertTrue((boolean)SystemUtil.normalizePath((String)"/home").endsWith(System.getProperty("file.separator")));
    }
}

