/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.collections;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.collections.BidiMap;
import com.github.hypfvieh.util.TypeUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Test;

public class BidiMapTest
extends AbstractBaseUtilTest {
    public void testConstructor1() {
        new BidiMap();
    }

    public void testConstructor2() {
        new BidiMap(new HashMap());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGet1() {
        BidiMap bidiMap = new BidiMap();
        bidiMap.get(null);
    }

    @Test
    public void testGetKey() {
        BidiMap bidiMap = new BidiMap(TypeUtil.createMap((Object[])new String[]{"K1", "V1"}));
        BidiMapTest.assertEquals((Object)"K1", (Object)bidiMap.getKey((Object)"V1"));
    }

    @Test
    public void testContainsValue() {
        BidiMap bidiMap = new BidiMap(TypeUtil.createMap((Object[])new String[]{"K1", "V1"}));
        BidiMapTest.assertTrue((boolean)bidiMap.containsValue((Object)"V1"));
    }

    @Test
    public void testKeySet() {
        BidiMap bidiMap = new BidiMap();
        BidiMapTest.assertTrue((boolean)bidiMap.keySet().getClass().getName().contains("UnmodifiableSet"));
    }

    @Test
    public void testValues() {
        BidiMap bidiMap = new BidiMap();
        BidiMapTest.assertTrue((boolean)bidiMap.values().getClass().getName().contains("UnmodifiableCollection"));
    }

    @Test
    public void testEntrySet() {
        BidiMap bidiMap = new BidiMap();
        BidiMapTest.assertTrue((boolean)bidiMap.entrySet().getClass().getName().contains("UnmodifiableSet"));
    }

    @Test(expected=RuntimeException.class)
    public void testRemove1() {
        BidiMap bidiMap = new BidiMap();
        bidiMap.remove(null);
    }

    @Test
    public void testRemove2() {
        Map map = TypeUtil.createMap((Object[])new String[]{"K1", "V1"});
        BidiMap bidiMap = new BidiMap(map);
        String removed = (String)bidiMap.remove((Object)"K1");
        BidiMapTest.assertEquals((Object)"V1", (Object)removed);
        BidiMapTest.assertFalse((boolean)bidiMap.containsKey((Object)"K1"));
        BidiMapTest.assertFalse((boolean)bidiMap.containsValue((Object)"V1"));
        BidiMapTest.assertTrue((boolean)map.containsKey("K1"));
        BidiMapTest.assertTrue((boolean)map.containsValue("V1"));
    }

    @Test(expected=RuntimeException.class)
    public void testRemoveValue1() {
        BidiMap bidiMap = new BidiMap();
        bidiMap.removeValue(null);
    }

    @Test
    public void testRemoveValue2() {
        Map map = TypeUtil.createMap((Object[])new String[]{"K1", "V1"});
        BidiMap bidiMap = new BidiMap(map);
        bidiMap.removeValue((Object)"V1");
    }

    @Test(expected=RuntimeException.class)
    public void testPutNull() {
        BidiMap bidiMap = new BidiMap();
        bidiMap.put((Object)"K1", null);
    }

    @Test
    public void testPutAgain() {
        BidiMap bidiMap = new BidiMap();
        bidiMap.put((Object)"K1", (Object)"V1");
        bidiMap.put((Object)"K1", (Object)"V1");
    }

    @Test(expected=RuntimeException.class)
    public void testPutKeysSameValue() {
        BidiMap bidiMap = new BidiMap();
        bidiMap.put((Object)"K1", (Object)"V1");
        bidiMap.put((Object)"K2", (Object)"V1");
    }

    @Test(expected=RuntimeException.class)
    public void testPutValuesSameKey() {
        BidiMap bidiMap = new BidiMap();
        bidiMap.put((Object)"K1", (Object)"V1");
        bidiMap.put((Object)"K1", (Object)"V2");
    }

    @Test
    public void testPutAll() {
        Map map = TypeUtil.createMap((Object[])new String[]{"K1", "V1", "K2", "V2", "K3", "V3"});
        BidiMap bidiMap = new BidiMap();
        bidiMap.putAll(map);
        BidiMapTest.assertEquals((long)map.size(), (long)bidiMap.size());
        BidiMapTest.assertEquals((Object)map, (Object)bidiMap);
    }

    @Test
    public void testClear() {
        Map map = TypeUtil.createMap((Object[])new String[]{"K1", "V1"});
        BidiMap bidiMap = new BidiMap(map);
        BidiMapTest.assertEquals((long)1L, (long)map.size());
        BidiMapTest.assertEquals((long)1L, (long)bidiMap.size());
        bidiMap.clear();
        BidiMapTest.assertEquals((long)1L, (long)map.size());
        BidiMapTest.assertEquals((long)0L, (long)bidiMap.size());
    }

    @Test
    public void testToString() {
        Map map = TypeUtil.createMap((Object[])new String[]{"K1", "V1"});
        BidiMap bidiMap = new BidiMap(map);
        BidiMapTest.assertContains(bidiMap.toString(), map.toString());
    }

    @Test
    public void testCreateMap() {
        Map hashMap = BidiMap.createMap(new HashMap());
        BidiMapTest.assertSame(HashMap.class, hashMap.getClass());
        Map hashTable = BidiMap.createMap(new Hashtable());
        BidiMapTest.assertSame(Hashtable.class, hashTable.getClass());
        Map treeMap = BidiMap.createMap(new TreeMap());
        BidiMapTest.assertSame(TreeMap.class, treeMap.getClass());
    }

    @Test(expected=RuntimeException.class)
    public void testCheckParms() {
        BidiMap.checkParms((Object[])new Object[]{null});
    }
}

