/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.util.TypeUtil;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.Test;

public class TypeUtilTest
extends AbstractBaseUtilTest {
    @Test
    public void testCreateProperties() {
        Properties props = TypeUtil.createProperties((String[])null);
        TypeUtilTest.assertNotNull((Object)props);
        TypeUtilTest.assertEquals((long)0L, (long)props.size());
        props = TypeUtil.createProperties((String[])new String[]{"k1", "v1", "k2", "v2"});
        TypeUtilTest.assertNotNull((Object)props);
        TypeUtilTest.assertEquals((long)2L, (long)props.size());
        Exception ex = null;
        try {
            props = TypeUtil.createProperties((String[])new String[]{"k1"});
        }
        catch (Exception _ex) {
            ex = _ex;
        }
        TypeUtilTest.assertNotNull((Object)ex);
    }

    @Test
    public void testIsInteger() {
        System.out.println("isInteger");
        String int1 = "0";
        String int2 = "-148832";
        String int3 = "4711";
        String int4 = "0.815";
        String int5 = "no int";
        String int6 = null;
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isInteger((String)int1));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isInteger((String)int2, (boolean)false));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isInteger((String)int2));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isInteger((String)int3));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isInteger((String)int4));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isInteger((String)int5));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isInteger(int6));
    }

    @Test
    public void testIsDouble() {
        System.out.println("isDouble");
        String int1 = "0";
        String int2 = "-0.45";
        String int3 = "4.711";
        String int4 = "0,815";
        String int5 = "no double";
        String int6 = null;
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isDouble((String)int1, (char)'.'));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isDouble((String)int2, (char)'.', (boolean)false));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isDouble((String)int2, (char)'.'));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isDouble((String)int3, (char)'.'));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isDouble((String)int4, (char)'.'));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isDouble((String)int5, (char)'.'));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isDouble(int6, (char)'.'));
    }

    @Test
    public void testIsValidNetworkPort() {
        System.out.println("isValidNetworkPort");
        int int1 = 4711;
        int int2 = 100000;
        int int3 = -2003;
        int int4 = 113;
        String port1 = "19393";
        String port2 = "100032";
        String port3 = "-19432";
        String port4 = "80";
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isValidNetworkPort((int)int1, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((int)int2, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((int)int3, (boolean)true));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isValidNetworkPort((int)int4, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((int)int4, (boolean)false));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isValidNetworkPort((String)port1, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((String)port2, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((String)port3, (boolean)true));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isValidNetworkPort((String)port4, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((String)port4, (boolean)false));
    }

    @Test
    public void testCreateMap() throws Exception {
        Map map = TypeUtil.createMap((Object[])new String[]{"1", "a", "2", "b", "3", "c", "4", "d"});
        TypeUtilTest.assertMap(map, "1", "2", "3", "4");
        TypeUtilTest.assertEquals((long)4L, (long)map.size());
        TypeUtilTest.assertEquals((Object)"a", map.get("1"));
        TypeUtilTest.assertTrue((boolean)map.containsKey("1"));
        TypeUtilTest.assertTrue((boolean)map.containsValue("a"));
    }

    @Test
    public void testCreateList() throws Exception {
        List list = TypeUtil.createList((Object[])new String[]{"u", "r", "gr8"});
        TypeUtilTest.assertCollection(list, "u", "r", "gr8");
        TypeUtilTest.assertNotNull((Object)TypeUtil.createList((Object[])new Object[0]));
        TypeUtilTest.assertNotNull((Object)TypeUtil.createList((Object[])null));
    }
}

