/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.common.SearchOrder;
import com.github.hypfvieh.util.FileIoUtil;
import com.github.hypfvieh.util.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import org.junit.Test;

public class FileIoUtilTest
extends AbstractBaseUtilTest {
    @Test
    public void testReadPropertiesBoolean() {
        System.out.println("readPropertiesBoolean");
        Properties props = new Properties();
        props.setProperty("bool1", "true");
        props.setProperty("bool2", "1");
        props.setProperty("bool3", "yes");
        props.setProperty("bool4", "enabled");
        props.setProperty("bool5", "on");
        props.setProperty("bool6", "yes");
        props.setProperty("bool7", "false");
        props.setProperty("bool8", "off");
        props.setProperty("bool9", "pingpongruebe");
        FileIoUtilTest.assertEquals((Object)true, (Object)FileIoUtil.readPropertiesBoolean((Properties)props, (String)"bool1"));
        FileIoUtilTest.assertEquals((Object)true, (Object)FileIoUtil.readPropertiesBoolean((Properties)props, (String)"bool2"));
        FileIoUtilTest.assertEquals((Object)true, (Object)FileIoUtil.readPropertiesBoolean((Properties)props, (String)"bool3"));
        FileIoUtilTest.assertEquals((Object)true, (Object)FileIoUtil.readPropertiesBoolean((Properties)props, (String)"bool4"));
        FileIoUtilTest.assertEquals((Object)true, (Object)FileIoUtil.readPropertiesBoolean((Properties)props, (String)"bool5"));
        FileIoUtilTest.assertEquals((Object)true, (Object)FileIoUtil.readPropertiesBoolean((Properties)props, (String)"bool6"));
        FileIoUtilTest.assertEquals((Object)false, (Object)FileIoUtil.readPropertiesBoolean((Properties)props, (String)"bool7"));
        FileIoUtilTest.assertEquals((Object)false, (Object)FileIoUtil.readPropertiesBoolean((Properties)props, (String)"bool8"));
        FileIoUtilTest.assertEquals((Object)false, (Object)FileIoUtil.readPropertiesBoolean((Properties)props, (String)"bool9"));
    }

    @Test
    public void testGetTextFileFromUrl() {
        System.out.println("getTextfileFromUrl");
        System.out.println("Working Directory = " + System.getProperty("user.dir"));
        String url = "file://" + System.getProperty("user.dir") + File.separator + "src/test/resources/FileIoUtilTest/getTextFileTest.txt";
        List textfileFromUrl = FileIoUtil.getTextfileFromUrl((String)url);
        FileIoUtilTest.assertFalse((textfileFromUrl.size() <= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadFileFrom() {
        String path = System.getProperty("user.dir") + File.separator + "src/test/resources/FileIoUtilTest/getTextFileTest.txt";
        List readFileFrom = FileIoUtil.readFileFrom((String)path, (Charset)Charset.defaultCharset(), (SearchOrder[])new SearchOrder[]{SearchOrder.SYSTEM_PATH, SearchOrder.CLASS_PATH, SearchOrder.CUSTOM_PATH});
        FileIoUtilTest.assertFalse((boolean)readFileFrom.isEmpty());
    }

    @Test
    public void testReadPropertiesFromStreamOk() throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream("src/test/resources/FileIoUtilTest/readProperties.properties");
        Properties readProperties = FileIoUtil.readProperties((InputStream)inputStream);
        FileIoUtilTest.assertEquals((Object)"Content", (Object)readProperties.getProperty("Other"));
    }

    @Test
    public void testReadPropertiesFromStreamFail() {
        Properties readProperties = FileIoUtil.readProperties((InputStream)null);
        FileIoUtilTest.assertNull((Object)readProperties);
    }

    @Test
    public void testReadPropertiesFromFileOk() {
        File propFile = new File("src/test/resources/FileIoUtilTest/readProperties.properties");
        Properties readProperties = FileIoUtil.readProperties((File)propFile);
        FileIoUtilTest.assertEquals((Object)"Content", (Object)readProperties.getProperty("Other"));
    }

    @Test
    public void testReadPropertiesFromFileFail() {
        File propFile = new File("src/test/resources/FileIoUtilTest/not_existing_readProperties.properties");
        Properties readProperties = FileIoUtil.readProperties((File)propFile);
        FileIoUtilTest.assertNull((Object)readProperties);
    }

    @Test
    public void testReadPropertiesFromFileWithInputPropertiesOk() {
        Properties properties = new Properties();
        properties.setProperty("key1", "val1");
        properties.setProperty("key2", "val2");
        Properties readProperties = FileIoUtil.readPropertiesFromFile((String)"src/test/resources/FileIoUtilTest/readProperties.properties", (Properties)properties);
        FileIoUtilTest.assertEquals((Object)"Content", (Object)readProperties.getProperty("Other"));
        FileIoUtilTest.assertEquals((Object)"val1", (Object)readProperties.getProperty("key1"));
    }

    @Test
    public void testReadPropertiesFromFileWithInputPropertiesFail() {
        Properties properties = new Properties();
        properties.setProperty("key1", "val1");
        properties.setProperty("key2", "val2");
        Properties readProperties = FileIoUtil.readPropertiesFromFile((String)"src/test/resources/FileIoUtilTest/not_existing_readProperties.properties", (Properties)properties);
        FileIoUtilTest.assertEquals((Object)"val1", (Object)readProperties.getProperty("key1"));
    }

    @Test
    public void testWritePropertiesToFileOk() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("key1", "val1");
        properties.setProperty("key2", "val2");
        File createTempFile = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName() + FileIoUtilTest.getMethodName(), ".properties");
        FileIoUtilTest.assertTrue((boolean)FileIoUtil.writeProperties((File)createTempFile, (Properties)properties));
        Properties readProperties = FileIoUtil.readProperties((File)createTempFile);
        FileIoUtilTest.assertEquals((Object)"val1", (Object)readProperties.getProperty("key1"));
        FileIoUtilTest.assertEquals((Object)"val2", (Object)readProperties.getProperty("key2"));
    }

    @Test
    public void testWritePropertiesFileAsStringOk() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("key1", "val1");
        properties.setProperty("key2", "val2");
        String fileName = SystemUtil.getTempDir() + ((Object)((Object)this)).getClass().getSimpleName() + FileIoUtilTest.getMethodName() + ".properties";
        FileIoUtilTest.assertTrue((boolean)FileIoUtil.writeProperties((String)fileName, (Properties)properties));
        File file = new File(fileName);
        file.deleteOnExit();
        Properties readProperties = FileIoUtil.readProperties((File)file);
        FileIoUtilTest.assertEquals((Object)"val1", (Object)readProperties.getProperty("key1"));
        FileIoUtilTest.assertEquals((Object)"val2", (Object)readProperties.getProperty("key2"));
        file.delete();
    }

    @Test
    public void testReadFileToStringFromString() {
        String readFileToString = FileIoUtil.readFileToString((String)"src/test/resources/FileIoUtilTest/getTextFileTest.txt");
        FileIoUtilTest.assertContains(readFileToString, "Lore Ipsum kann");
    }

    @Test
    public void testReadFileToStringFromFile() {
        String readFileToString = FileIoUtil.readFileToString((File)new File("src/test/resources/FileIoUtilTest/getTextFileTest.txt"));
        FileIoUtilTest.assertContains(readFileToString, "Lore Ipsum kann");
    }

    @Test
    public void testReadFileToListOfStringFromString() {
        List readFileToString = FileIoUtil.readFileToList((String)"src/test/resources/FileIoUtilTest/getTextFileTest.txt");
        FileIoUtilTest.assertEquals((long)2L, (long)readFileToString.size());
        FileIoUtilTest.assertContains((String)readFileToString.get(1), "Lore Ipsum kann");
    }

    @Test
    public void testReadFileToListOfStringFromFile() {
        List readFileToString = FileIoUtil.readFileToList((File)new File("src/test/resources/FileIoUtilTest/getTextFileTest.txt"));
        FileIoUtilTest.assertEquals((long)2L, (long)readFileToString.size());
        FileIoUtilTest.assertContains((String)readFileToString.get(1), "Lore Ipsum kann");
    }

    @Test
    public void testReadStringFromResourcesOk() throws FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream("src/test/resources/FileIoUtilTest/getTextFileTest.txt");
        String readStringFromResources = FileIoUtil.readStringFromResources((InputStream)fileInputStream, (String)Charset.defaultCharset().toString());
        FileIoUtilTest.assertContains(readStringFromResources, "Lore Ipsum kann");
    }

    @Test
    public void testReadStringFromResourcesFail() {
        String readStringFromResources = FileIoUtil.readStringFromResources(null, (String)Charset.defaultCharset().toString());
        FileIoUtilTest.assertNull((Object)readStringFromResources);
    }

    @Test
    public void testLoadPropertiesFromClassPathOk() throws IOException {
        Properties loadPropertiesFromClasspath = FileIoUtil.loadPropertiesFromClasspath((String)"FileIoUtilTest/readProperties.properties");
        FileIoUtilTest.assertEquals((Object)"More", (Object)loadPropertiesFromClasspath.getProperty("Even"));
    }

    @Test(expected=IOException.class)
    public void testLoadPropertiesFromClassPathFail() throws IOException {
        FileIoUtil.loadPropertiesFromClasspath((String)"FileIoUtilTest/not_existing_readProperties.properties");
    }

    @Test
    public void testLoadPropertiesFromClassPathWithInputPropertiesOk() {
        Properties properties = new Properties();
        properties.setProperty("key1", "val1");
        properties.setProperty("key2", "val2");
        FileIoUtilTest.assertTrue((boolean)FileIoUtil.loadPropertiesFromClasspath((String)"FileIoUtilTest/readProperties.properties", (Properties)properties));
        FileIoUtilTest.assertEquals((Object)"More", (Object)properties.getProperty("Even"));
        FileIoUtilTest.assertEquals((Object)"val1", (Object)properties.getProperty("key1"));
    }

    @Test
    public void testLoadPropertiesFromClassPathWithInputPropertiesFail() {
        Properties properties = new Properties();
        properties.setProperty("key1", "val1");
        properties.setProperty("key2", "val2");
        FileIoUtilTest.assertFalse((boolean)FileIoUtil.loadPropertiesFromClasspath((String)"FileIoUtilTest/not_existing_readProperties.properties", (Properties)properties));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadPropertiesFromClassPathWithInputPropertiesIllegalInput() {
        FileIoUtil.loadPropertiesFromClasspath((String)"FileIoUtilTest/not_existing_readProperties.properties", null);
    }

    @Test
    public void testReadFileFromClassPathOk() {
        String readFileFromClassPath = FileIoUtil.readFileFromClassPath((String)"FileIoUtilTest/getTextFileTest.txt");
        FileIoUtilTest.assertContains(readFileFromClassPath, "Lore Ipsum kann");
    }

    @Test
    public void testReadFileFromClassPathFail() {
        FileIoUtilTest.assertNull((Object)FileIoUtil.readFileFromClassPath(null));
    }

    @Test
    public void testWriteTextFileNoAppendOk() throws IOException {
        String createTempFile = SystemUtil.getTempDir() + ((Object)((Object)this)).getClass().getSimpleName() + FileIoUtilTest.getMethodName() + ".txt";
        String newFileContent = "This is only a test\nWith some lines\nin it.";
        FileIoUtilTest.assertTrue((boolean)FileIoUtil.writeTextFile((String)createTempFile, (String)newFileContent, (Charset)Charset.defaultCharset(), (boolean)false));
        File file = new File(createTempFile);
        file.deleteOnExit();
        List readTextFileFromStream = FileIoUtil.readTextFileFromStream((InputStream)new FileInputStream(file), (Charset)Charset.defaultCharset(), (boolean)true);
        FileIoUtilTest.assertEquals((long)3L, (long)readTextFileFromStream.size());
        FileIoUtilTest.assertEquals((Object)"This is only a test", readTextFileFromStream.get(0));
        FileIoUtilTest.assertEquals((Object)"With some lines", readTextFileFromStream.get(1));
        FileIoUtilTest.assertEquals((Object)"in it.", readTextFileFromStream.get(2));
        file.delete();
    }

    @Test
    public void testWriteTextFileAppendOk() throws IOException {
        String createTempFile = SystemUtil.getTempDir() + ((Object)((Object)this)).getClass().getSimpleName() + FileIoUtilTest.getMethodName() + ".txt";
        File file = new File(createTempFile);
        if (file.exists()) {
            file.delete();
        }
        Files.copy(Paths.get("src/test/resources/FileIoUtilTest/getTextFileTest.txt", new String[0]), Paths.get(createTempFile, new String[0]), new CopyOption[0]);
        String newFileContent = "This is only a test\nWith some lines\nin it.";
        FileIoUtilTest.assertTrue((boolean)FileIoUtil.writeTextFile((String)createTempFile, (String)newFileContent, (Charset)Charset.defaultCharset(), (boolean)true));
        file.deleteOnExit();
        List readTextFileFromStream = FileIoUtil.readTextFileFromStream((InputStream)new FileInputStream(file), (Charset)Charset.defaultCharset(), (boolean)true);
        FileIoUtilTest.assertEquals((long)5L, (long)readTextFileFromStream.size());
        FileIoUtilTest.assertEquals((Object)"Lirum Larum Loeffelstiel", readTextFileFromStream.get(0));
        FileIoUtilTest.assertEquals((Object)"Lore Ipsum kann nicht viel", readTextFileFromStream.get(1));
        FileIoUtilTest.assertEquals((Object)"This is only a test", readTextFileFromStream.get(2));
        FileIoUtilTest.assertEquals((Object)"With some lines", readTextFileFromStream.get(3));
        FileIoUtilTest.assertEquals((Object)"in it.", readTextFileFromStream.get(4));
        file.delete();
    }

    @Test
    public void testGuessLineTerminatorOfFile() throws IOException {
        String unixLineFeed = FileIoUtil.guessLineTerminatorOfFile((String)"src/test/resources/FileIoUtilTest/guessLineTerminatorOfFileUnix.txt");
        String windowsLineFeed = FileIoUtil.guessLineTerminatorOfFile((String)"src/test/resources/FileIoUtilTest/guessLineTerminatorOfFileWindows.txt");
        String macOs9LineFeed = FileIoUtil.guessLineTerminatorOfFile((String)"src/test/resources/FileIoUtilTest/guessLineTerminatorOfFileMacOs9.txt");
        FileIoUtilTest.assertEquals((Object)"\n", (Object)unixLineFeed);
        FileIoUtilTest.assertEquals((Object)"\r\n", (Object)windowsLineFeed);
        FileIoUtilTest.assertEquals((Object)"\r", (Object)macOs9LineFeed);
    }
}

