/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.classloader;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.classloader.ComponentRegistry;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ComponentRegistryTest
extends AbstractBaseUtilTest {
    @Test
    public void testGetInstance() {
        ComponentRegistry result = new ComponentRegistry();
        ComponentRegistryTest.assertNotNull((Object)result);
        ComponentRegistryTest.assertEquals((Object)ComponentRegistry.class.getName(), (Object)result.getClass().getName());
    }

    @Test
    public void testClearPackageIncludeList() {
        String testClass = "com.github.hypfvieh.classloader.ComponentRegistryTest$LoaderTest";
        ComponentRegistry instance = new ComponentRegistry();
        instance.addPackageToIncludeList(testClass);
        instance.clearPackageIncludeList();
        instance.registerComponent(testClass);
        ComponentRegistryTest.assertEquals((int)1, (int)instance.getComponents().size());
    }

    @Test
    public void testGetComponentsVersions() {
        ComponentRegistry instance = new ComponentRegistry();
        Map result = instance.getComponentsVersions();
        ComponentRegistryTest.assertEquals((int)1, (int)result.size());
    }

    @Test
    public void testGetComponents() {
        ComponentRegistry instance = new ComponentRegistry();
        List result = instance.getComponents();
        ComponentRegistryTest.assertEquals((int)1, (int)result.size());
    }

    @Test
    public void testAddPackageToIncludeList() {
        String testClass = "com.github.hypfvieh.classloader.ComponentRegistryTest$LoaderTest";
        ComponentRegistry instance = new ComponentRegistry();
        instance.addPackageToIncludeList(testClass);
        instance.registerComponent(testClass);
        ComponentRegistryTest.assertEquals((int)2, (int)instance.getComponents().size());
    }

    @Test
    public void testUnregisterComponent() {
        String testClass = "com.github.hypfvieh.classloader.ComponentRegistryTest$LoaderTest";
        ComponentRegistry instance = new ComponentRegistry();
        instance.addPackageToIncludeList(testClass);
        instance.registerComponent(testClass);
        ComponentRegistryTest.assertEquals((int)2, (int)instance.getComponents().size());
        ComponentRegistryTest.assertEquals((int)2, (int)instance.getComponentsVersions().size());
        instance.unregisterComponent(testClass);
        ComponentRegistryTest.assertEquals((int)1, (int)instance.getComponents().size());
        ComponentRegistryTest.assertEquals((int)1, (int)instance.getComponentsVersions().size());
    }

    public static class LoaderTest {
        private static final String version = "1.0.2-BETA-4";

        public static void run(List<String> args) {
            System.out.println("    --> Running!");
            int i = 0;
            for (String arg : args) {
                System.out.println("Argument " + i + ": " + arg);
                ++i;
            }
        }

        public static String getVersion() {
            return version;
        }
    }
}

