/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.files;

import com.github.hypfvieh.files.RollingFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class RollingFileUtilTest {
    private static File testSource;
    private static List<File> createdTempFiles;

    @BeforeAll
    public static void beforeAll() throws IOException {
        testSource = RollingFileUtilTest.createTempFile();
        createdTempFiles.add(testSource);
    }

    @AfterAll
    public static void afterAll() {
        if (!createdTempFiles.isEmpty()) {
            createdTempFiles.forEach(f -> f.delete());
        }
    }

    static File createTempFile() throws IOException {
        return File.createTempFile("rolling-test", ".tmp");
    }

    @Test
    public void testBrokenPlaceholderRepeated() throws IOException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RollingFileUtil.doFileRolling((File)testSource, (String)"%{n}-broken-%{n}", (int)10));
    }

    @Test
    public void testBrokenPlaceholderMissing() throws IOException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> RollingFileUtil.doFileRolling((File)testSource, (String)"broken", (int)10));
    }

    @Test
    public void testRolling5() throws IOException {
        RollingFileUtil.doFileRolling((File)RollingFileUtilTest.createTempFile(), (String)"rollover5-%{n}.%{ext}", (int)5);
        RollingFileUtil.doFileRolling((File)RollingFileUtilTest.createTempFile(), (String)"rollover5-%{n}.%{ext}", (int)5);
        RollingFileUtil.doFileRolling((File)RollingFileUtilTest.createTempFile(), (String)"rollover5-%{n}.%{ext}", (int)5);
        RollingFileUtil.doFileRolling((File)RollingFileUtilTest.createTempFile(), (String)"rollover5-%{n}.%{ext}", (int)5);
        RollingFileUtil.doFileRolling((File)RollingFileUtilTest.createTempFile(), (String)"rollover5-%{n}.%{ext}", (int)5);
        final ArrayList toDeleteLater = new ArrayList();
        Files.walkFileTree(testSource.getParentFile().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().getName().startsWith("rollover5-")) {
                    toDeleteLater.add(file.toFile());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        Assertions.assertEquals((int)5, (int)toDeleteLater.size());
        toDeleteLater.forEach(f -> f.delete());
    }

    @Test
    public void testRolling3WithDate() throws IOException {
        RollingFileUtil.doFileRolling((File)RollingFileUtilTest.createTempFile(), (String)"rolloverWithDate3-%{date:yyyy-MM-dd}_%{n}.%{ext}", (int)3);
        RollingFileUtil.doFileRolling((File)RollingFileUtilTest.createTempFile(), (String)"rolloverWithDate3-%{date:yyyy-MM-dd}_%{n}.%{ext}", (int)3);
        RollingFileUtil.doFileRolling((File)RollingFileUtilTest.createTempFile(), (String)"rolloverWithDate3-%{date:yyyy-MM-dd}_%{n}.%{ext}", (int)3);
        final ArrayList toDeleteLater = new ArrayList();
        Files.walkFileTree(testSource.getParentFile().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().getName().startsWith("rolloverWithDate3-")) {
                    toDeleteLater.add(file.toFile());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        Assertions.assertEquals((int)3, (int)toDeleteLater.size());
        toDeleteLater.forEach(f -> f.delete());
    }

    static {
        createdTempFiles = new ArrayList<File>();
    }
}

