/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.formatter;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.formatter.TableColumnFormatter;
import com.github.hypfvieh.util.StringUtil;
import org.junit.jupiter.api.Test;

public class TableColumnFormatterTest
extends AbstractBaseUtilTest {
    @Test
    public void testConstructorMissingSplitOperator() {
        TableColumnFormatterTest.assertThrows(NullPointerException.class, () -> new TableColumnFormatter(null, new int[]{2, 3, 4}));
    }

    @Test
    public void testConstructorInvalidColumnWidths() {
        TableColumnFormatterTest.assertThrows(IllegalArgumentException.class, () -> new TableColumnFormatter(StringUtil::splitEqually, new int[]{2, -3, 4}));
    }

    @Test
    public void testFormatLine() {
        TableColumnFormatter tableColumnFormatter = new TableColumnFormatter(StringUtil::splitEqually, '_', new int[]{1, 2, 3});
        TableColumnFormatterTest.assertEquals((Object)"1_2__3__", (Object)tableColumnFormatter.formatLine(new String[]{"1", "2", "3"}));
        TableColumnFormatterTest.assertEquals((Object)"1_______", (Object)tableColumnFormatter.formatLine(new String[]{"1"}));
        TableColumnFormatterTest.assertEquals((Object)"________", (Object)tableColumnFormatter.formatLine((String[])null));
        TableColumnFormatterTest.assertEquals((Object)"A_______\nB_______\nC_______", (Object)tableColumnFormatter.formatLine(new String[]{"ABC"}));
    }
}

