/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.util.FixUtil;
import org.junit.jupiter.api.Test;

public class FixUtilTest
extends AbstractBaseUtilTest {
    private String sampleFixMsg = "8=FIX.4.2|9=65|35=0|49=TRIOMM|56=BAADER_UAT_AUC_DC|34=1992|52=20140714-21:29:29|10=149|";

    @Test
    public void testGetDelimiterFromFixMsgStr() {
        System.out.println("getDelimiterFromFixMsgStr");
        String expResult = "|";
        String result = FixUtil.getDelimiterFromFixMsgStr((String)this.sampleFixMsg);
        FixUtilTest.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testSetFixTagOnMsgStr() {
        System.out.println("setFixTagOnMsgStr");
        String expResult = "8=FIX.4.2|9=65|35=0|49=TRIOMM|56=BAADER_UAT_AUC_DC|34=1992|52=20140714-21:29:29|4711=FOOBAR|10=149|";
        String result = FixUtil.setFixTagOnMsgStr((String)this.sampleFixMsg, (int)4711, (String)"FOOBAR");
        FixUtilTest.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testCalculateFixBodyLength() {
        System.out.println("calculateFixBodyLength");
        String brokenMsg = this.sampleFixMsg;
        FixUtil.setFixTagOnMsgStr((String)brokenMsg, (int)10, (String)"815");
        int expectValue = 65;
        int calcValue = FixUtil.calculateFixBodyLength((String)brokenMsg);
        FixUtilTest.assertEquals((int)expectValue, (int)calcValue);
    }

    @Test
    public void testCalculateFixCheckSum() {
        System.out.println("calculateFixCheckSum");
        String expResult = "149";
        String result = FixUtil.calculateFixCheckSum((String)this.sampleFixMsg, (char)"|".charAt(0));
        FixUtilTest.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testLooksLikeFixMsg() {
        System.out.println("looksLikeFixMsg");
        boolean expResult = true;
        boolean result = FixUtil.looksLikeFixMsg((String)this.sampleFixMsg);
        FixUtilTest.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testSetValueCorrectOrder() {
        System.out.println("setValue and correct order");
        String testMsg = "9=65|49=TRIOMM|56=BAADER_UAT_AUC_DC|8=FIX.4.2|34=1992|52=20140714-21:29:29|35=0|4711=FOO|10=149|";
        String expResult = "8=FIX.4.2|9=65|35=0|49=TRIOMM|56=BAADER_UAT_AUC_DC|34=1992|52=20140714-21:29:29|4711=FOOBAR|10=149|";
        FixUtilTest.assertEquals((Object)expResult, (Object)FixUtil.setFixTagOnMsgStr((String)testMsg, (int)4711, (String)"FOOBAR"));
    }
}

