/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.util.ReflectionUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Test;

public class ReflectionUtilTest
extends AbstractBaseUtilTest {
    @Test
    public void testGetAllDeclaredFields() {
        Set allDeclaredFields = ReflectionUtil.getAllDeclaredFields(TestClass3.class, (String[])new String[0]);
        List cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "field1", "field2", "field3", "staticField1");
        allDeclaredFields = ReflectionUtil.getAllDeclaredFields(TestClass2.class, (String[])new String[0]);
        cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "field1", "field2", "field3");
        allDeclaredFields = ReflectionUtil.getAllDeclaredFields(TestClass1.class, (String[])new String[0]);
        cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "field1", "field2");
        allDeclaredFields = ReflectionUtil.getAllDeclaredFields(TestClass2.class, (String[])new String[]{"field2"});
        cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "field1", "field3");
        ReflectionUtilTest.assertFalse((boolean)cll.contains("field2"));
    }

    @Test
    public void testGetAllDeclaredStaticFields() {
        Set allDeclaredFields = ReflectionUtil.getAllDeclaredStaticFields(TestClass3.class, (String[])new String[0]);
        List cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "staticField1");
        allDeclaredFields = ReflectionUtil.getAllDeclaredStaticFields(TestClass1.class, (String[])new String[]{"$jacocoData"});
        ReflectionUtilTest.assertTrue((boolean)allDeclaredFields.isEmpty(), (String)("Expected no declared static fields in " + TestClass1.class + " but got: " + allDeclaredFields));
        allDeclaredFields = ReflectionUtil.getAllDeclaredStaticFields(TestClass2.class, (String[])new String[]{"$jacocoData"});
        ReflectionUtilTest.assertTrue((boolean)allDeclaredFields.isEmpty(), (String)("Expected no declared static fields in " + TestClass2.class + " but got: " + allDeclaredFields));
    }

    @Test
    public void testGetAllDeclaredNonStaticFields() {
        Set allDeclaredFields = ReflectionUtil.getAllDeclaredNonStaticFields(TestClass3.class, (String[])new String[0]);
        List cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertFalse((boolean)cll.contains("staticField1"));
        allDeclaredFields = ReflectionUtil.getAllDeclaredNonStaticFields(TestClass1.class, (String[])new String[0]);
        ReflectionUtilTest.assertFalse((boolean)allDeclaredFields.isEmpty());
        allDeclaredFields = ReflectionUtil.getAllDeclaredNonStaticFields(TestClass2.class, (String[])new String[0]);
        ReflectionUtilTest.assertFalse((boolean)allDeclaredFields.isEmpty());
    }

    @Test
    public void testGetAllDeclaredAnnotatedFields() {
        Set allDeclaredFields = ReflectionUtil.getAllDeclaredFieldsAnnotatedWithAny(TestClass3.class, (Class[])new Class[]{DummyAnnotation.class});
        List cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "field1", "field3");
        allDeclaredFields = ReflectionUtil.getAllDeclaredNonStaticFields(TestClass3.class, (String[])new String[0]);
        ReflectionUtilTest.assertFalse((boolean)allDeclaredFields.isEmpty());
    }

    @Test
    public void testGetAllDeclaredNotAnnotatedFields() {
        Set allDeclaredFields = ReflectionUtil.getAllDeclaredFieldsNotAnnotatedWithAny(TestClass3.class, (Class[])new Class[]{DummyAnnotation.class});
        List cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "field2", "staticField1");
    }

    @Test
    public void testGetAllDeclaredMethods() {
        Set allDeclaredFields = ReflectionUtil.getAllDeclared(TestClass3.class, Method.class);
        List cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "testMethod1", "testMethod2", "testMethod3");
        allDeclaredFields = ReflectionUtil.getAllDeclared(TestClass2.class, Method.class);
        cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "testMethod1", "testMethod2");
        allDeclaredFields = ReflectionUtil.getAllDeclared(TestClass1.class, Method.class);
        cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "testMethod1");
    }

    @Test
    public void testGetAllDeclaredStaticMethods() {
        Set allDeclaredFields = ReflectionUtil.getAllDeclaredStaticMethods(TestClass3.class, (String[])new String[0]);
        List cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "testMethod3");
        ReflectionUtilTest.assertFalse((boolean)cll.contains("testMethod1"));
        allDeclaredFields = ReflectionUtil.getAllDeclaredStaticMethods(TestClass1.class, (String[])new String[]{"$jacocoData", "registerNatives"});
        ReflectionUtilTest.assertTrue((boolean)allDeclaredFields.isEmpty(), (String)("Expected no declared static methods in " + TestClass1.class + " but got: " + allDeclaredFields));
        allDeclaredFields = ReflectionUtil.getAllDeclaredStaticMethods(TestClass2.class, (String[])new String[]{"$jacocoData", "registerNatives"});
        ReflectionUtilTest.assertTrue((boolean)allDeclaredFields.isEmpty(), (String)("Expected no declared static methods in " + TestClass2.class + " but got: " + allDeclaredFields));
    }

    @Test
    public void testGetAllDeclaredNonStaticMethods() {
        Set allDeclaredFields = ReflectionUtil.getAllDeclaredNonStaticMethods(TestClass3.class, (String[])new String[0]);
        List cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertFalse((boolean)cll.contains("testMethod3"));
        ReflectionUtilTest.assertTrue((boolean)cll.contains("testMethod1"));
        allDeclaredFields = ReflectionUtil.getAllDeclaredNonStaticMethods(TestClass1.class, (String[])new String[0]);
        ReflectionUtilTest.assertFalse((boolean)allDeclaredFields.isEmpty());
        allDeclaredFields = ReflectionUtil.getAllDeclaredNonStaticMethods(TestClass2.class, (String[])new String[0]);
        ReflectionUtilTest.assertFalse((boolean)allDeclaredFields.isEmpty());
    }

    @Test
    public void testGetAllDeclaredAnnotatedMethods() {
        Set allDeclaredFields = ReflectionUtil.getAllDeclaredMethodsAnnotatedWithAny(TestClass3.class, (Class[])new Class[]{DummyAnnotation.class});
        List cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "testMethod2");
    }

    @Test
    public void testGetAllDeclaredNotAnnotatedMethods() {
        Set allDeclaredFields = ReflectionUtil.getAllDeclaredMethodsNotAnnotatedWithAny(TestClass3.class, (Class[])new Class[]{DummyAnnotation.class});
        List cll = allDeclaredFields.stream().map(f -> f.getName()).collect(Collectors.toList());
        ReflectionUtilTest.assertCollection(cll, "testMethod1", "testMethod3");
    }

    static class TestClass3
    extends TestClass2 {
        private static int staticField1;

        TestClass3() {
        }

        private static void testMethod3() {
        }
    }

    static class TestClass2
    extends TestClass1 {
        @DummyAnnotation
        private int field3;

        TestClass2() {
        }

        @DummyAnnotation
        private void testMethod2() {
        }
    }

    static class TestClass1 {
        @DummyAnnotation
        private int field1;
        private int field2;

        TestClass1() {
        }

        private void testMethod1() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface DummyAnnotation {
    }
}

