/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.util.TimeMeasure;
import org.junit.jupiter.api.Test;

public class TimeMeasureTest
extends AbstractBaseUtilTest {
    @Test
    public void testTimeMeasure() {
        TimeMeasure tm = new TimeMeasure();
        TimeMeasureTest.assertTrue((tm.getElapsed() >= 0L ? 1 : 0) != 0);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException _ex) {
            TimeMeasureTest.assertTrue((boolean)true);
        }
        TimeMeasureTest.assertTrue((tm.getElapsed() >= 100L ? 1 : 0) != 0);
        TimeMeasureTest.assertTrue((boolean)tm.toString().matches("^[0-9]+ms$"), (String)("toString() returned " + tm));
        tm.reset();
        long elapsed = tm.getElapsed();
        TimeMeasureTest.assertTrue((elapsed < 10L ? 1 : 0) != 0);
        tm.setStartTm(tm.getStartTime() - 10000L);
        elapsed = tm.getElapsed();
        TimeMeasureTest.assertTrue((elapsed >= 10000L ? 1 : 0) != 0, (String)("Elapsed was " + elapsed));
        TimeMeasureTest.assertTrue((boolean)tm.toString().matches("^[0-9]+\\.[0-9]s$"), (String)("toString() returned " + tm));
    }

    @Test
    public void testTimeMeasureFormatter() {
        TimeMeasure tm = new TimeMeasure();
        String oneSecond = tm.getElapsedFormatted(null, 1000L);
        TimeMeasureTest.assertEquals((Object)"00:00:01.000", (Object)oneSecond);
        String oneMinuteoneSecond = tm.getElapsedFormatted(null, 61000L);
        TimeMeasureTest.assertEquals((Object)"00:01:01.000", (Object)oneMinuteoneSecond);
        String threeSecondsAfewMillis = tm.getElapsedFormatted(null, 3721L);
        TimeMeasureTest.assertEquals((Object)"00:00:03.721", (Object)threeSecondsAfewMillis);
    }
}

