/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class BidiMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map;
    private final Map<V, K> inverseMap;

    public BidiMap() {
        this(null);
    }

    public BidiMap(Map<K, V> _map) {
        this.map = BidiMap.createMap(_map);
        this.inverseMap = BidiMap.createMap(this.map);
        if (_map != null) {
            this.putAll(_map);
        }
    }

    @Override
    public V get(Object _key) {
        BidiMap.checkParms(_key);
        return this.map.get(_key);
    }

    public K getKey(V _val) {
        BidiMap.checkParms(_val);
        return this.inverseMap.get(_val);
    }

    @Override
    public boolean containsKey(Object _key) {
        BidiMap.checkParms(_key);
        return this.map.containsKey(_key);
    }

    @Override
    public boolean containsValue(Object _val) {
        BidiMap.checkParms(_val);
        return this.inverseMap.containsKey(_val);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    @Override
    public V remove(Object _key) {
        BidiMap.checkParms(_key);
        V removedValue = this.map.remove(_key);
        if (removedValue != null) {
            this.inverseMap.remove(removedValue);
        }
        return removedValue;
    }

    public K removeValue(V _val) {
        BidiMap.checkParms(_val);
        K removedKey = this.inverseMap.remove(_val);
        if (removedKey != null) {
            this.map.remove(removedKey);
        }
        return removedKey;
    }

    @Override
    public V put(K _key, V _val) {
        BidiMap.checkParms(_key, _val);
        K invKey = this.inverseMap.get(_val);
        if (invKey == null) {
            if (this.containsKey(_key)) {
                throw new IllegalArgumentException("Key [" + _key + "] not unique in bidirectional map, cannot put(" + _key + ", " + _val + ").");
            }
        } else if (!_key.equals(invKey)) {
            throw new IllegalArgumentException("Value [" + _val + "] not unique in bidirectional map, cannot put(" + _key + ", " + _val + ").");
        }
        V prevVal = this.map.put(_key, _val);
        this.inverseMap.put(_val, _key);
        return prevVal;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> _map) {
        for (Map.Entry<K, V> entry : _map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.inverseMap.clear();
    }

    public final String toString() {
        return this.getClass().getName() + "[" + this.map + "]";
    }

    static Map<?, ?> createMap(Map<?, ?> _map) {
        Map newMap;
        try {
            newMap = (Map)_map.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception _ex) {
            newMap = new LinkedHashMap();
        }
        return newMap;
    }

    static void checkParms(Object ... _objs) {
        if (_objs != null) {
            for (Object obj : _objs) {
                if (obj != null) continue;
                throw new IllegalArgumentException("Null parameter not allowed.");
            }
        }
    }
}

