/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.config.xml;

import com.github.hypfvieh.common.SearchOrder;
import com.github.hypfvieh.config.xml.ConfigurationException;
import com.github.hypfvieh.config.xml.XmlConfiguration;
import com.github.hypfvieh.util.xml.XmlErrorHandlers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xml.sax.ErrorHandler;

public class XmlConfigBuilder {
    private InputStream inputStream;
    private OutputStream outputStream;
    private File outputFile;
    private File inputFile;
    private ErrorHandler errorHandler = new XmlErrorHandlers.XmlErrorHandlerQuiet();
    private String delimiterKey;
    private boolean skipRoot;
    private boolean allowOverride;

    public XmlConfigBuilder setInputStream(InputStream _inputStream) {
        if (this.inputFile != null) {
            throw new ConfigurationException("Cannot set inputStream as inputFile is already set.");
        }
        this.inputStream = _inputStream;
        return this;
    }

    public XmlConfigBuilder setOutputStream(OutputStream _outputStream) {
        if (this.outputFile != null) {
            throw new ConfigurationException("Cannot set outputStream as outputFile is already set.");
        }
        this.outputStream = _outputStream;
        return this;
    }

    public XmlConfigBuilder setOutputFile(File _outputFile) {
        if (this.outputStream != null) {
            throw new ConfigurationException("Cannot set outputFile as outputStream is already set.");
        }
        this.outputFile = _outputFile;
        return this;
    }

    public XmlConfigBuilder setOutputFile(String _outputFile) {
        return this.setOutputFile(new File(_outputFile));
    }

    public XmlConfigBuilder setInputFile(File _inputFile, SearchOrder ... _order) {
        if (this.inputStream != null) {
            throw new ConfigurationException("Cannot set inputFile as inputStream is already set.");
        }
        if (_order == null || _order.length == 0) {
            _order = new SearchOrder[]{SearchOrder.CUSTOM_PATH, SearchOrder.CLASS_PATH};
        }
        InputStream findFile = SearchOrder.findFile(_inputFile.toString(), _order);
        this.inputFile = _inputFile;
        this.inputStream = findFile;
        return this;
    }

    public XmlConfigBuilder setInputFile(String _inputFile, SearchOrder ... _order) {
        return this.setInputFile(new File(_inputFile), _order);
    }

    public XmlConfigBuilder setXmlErrorHandler(ErrorHandler _xmlErrorHandler) {
        this.errorHandler = _xmlErrorHandler;
        return this;
    }

    public XmlConfigBuilder setKeyDelimiter(String _delimiterKey) {
        this.delimiterKey = _delimiterKey;
        return this;
    }

    public XmlConfigBuilder setSkipRoot(boolean _skipRoot) {
        this.skipRoot = _skipRoot;
        return this;
    }

    public XmlConfigBuilder setAllowKeyOverrideFromEnvironment(boolean _allowOverride) {
        this.allowOverride = _allowOverride;
        return this;
    }

    public XmlConfiguration build() {
        XmlConfiguration xmlConfiguration = new XmlConfiguration(this.skipRoot);
        xmlConfiguration.setKeyDelimiter(this.delimiterKey);
        xmlConfiguration.setXmlErrorHandler(this.errorHandler);
        xmlConfiguration.setAllowOverride(this.allowOverride);
        xmlConfiguration.setInputStream(this.inputStream);
        xmlConfiguration.setOutputStream(this.outputStream);
        xmlConfiguration.setInputFile(this.inputFile);
        xmlConfiguration.setOutputFile(this.outputFile);
        try {
            xmlConfiguration.readAndValidate();
        }
        catch (IOException _ex) {
            throw new ConfigurationException(_ex);
        }
        return xmlConfiguration;
    }
}

