/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.db;

import java.util.Map;

public class DbConnParms {
    private final String url;
    private final String user;
    private final String password;
    private final String driverClassName;
    private final int maxRetries;

    public DbConnParms(String _url, String _user, String _password, String _driverClassName) {
        this(_url, _user, _password, _driverClassName, 3);
    }

    public DbConnParms(String _url, String _user, String _password, String _driverClassName, int _maxRetries) {
        if (_url == null || _user == null || _driverClassName == null) {
            throw new IllegalArgumentException("Url, user, driverClassName required to create new " + this.getClass().getName() + ".");
        }
        this.url = _url;
        this.user = _user;
        this.password = _password;
        this.driverClassName = _driverClassName;
        this.maxRetries = _maxRetries;
    }

    public DbConnParms(Map<String, String> _parms) {
        this(_parms.get("URL"), _parms.get("USER"), _parms.get("PASS"), _parms.get("DRIVER"));
    }

    public String toString() {
        String pw = this.password == null || this.password.isEmpty() ? "NO_PASSWORD_SET" : "****";
        return this.getClass().getSimpleName() + "[url=" + this.url + ", user=" + this.user + ", password=" + pw + ", dbDriver=" + this.driverClassName + ", maxRetries=" + this.maxRetries + "']";
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }
}

