/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.db;

import com.github.hypfvieh.db.DbConnParms;
import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.TypeUtil;
import java.io.InvalidClassException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDatabaseConnector {
    private final Logger logger;
    private final AtomicInteger connectionRetries;
    private boolean dbOpen = false;
    private boolean supportsBatch = false;
    private DbConnParms connectionParams = null;
    private Connection dbConnection = null;

    public SimpleDatabaseConnector(DbConnParms _connectionParams) {
        if (_connectionParams == null) {
            throw new IllegalArgumentException("Database connection parameters cannot be null.");
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.dbOpen = false;
        this.connectionParams = _connectionParams;
        this.connectionRetries = new AtomicInteger(0);
    }

    public final synchronized boolean openDatabase() throws InvalidClassException, ClassNotFoundException {
        if (this.dbOpen) {
            this.logger.warn("Connection to database already opened.");
            return this.dbOpen;
        }
        try {
            Class<?> driverClazz = Class.forName(this.connectionParams.getDriverClassName());
            Object driverInstance = driverClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(driverInstance instanceof Driver)) {
                this.logger.error("{} does not implement java.sql.Driver interface!", (Object)this.connectionParams.getDriverClassName());
                throw new InvalidClassException(this.connectionParams.getDriverClassName() + " does not implement java.sql.Driver interface!");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException _ex) {
            this.logger.error("Cannot instanciate database driver: " + this.connectionParams.getDriverClassName(), (Throwable)_ex);
        }
        this.openConnection();
        if (this.dbOpen && this.dbConnection != null) {
            try {
                if (this.dbConnection.getMetaData().supportsBatchUpdates()) {
                    this.supportsBatch = true;
                }
            }
            catch (SQLException _ex) {
                this.logger.info("Could not determine if database supports batch update feature.", (Throwable)_ex);
            }
        }
        return this.dbOpen;
    }

    private void openConnection() {
        try {
            this.dbConnection = DriverManager.getConnection(this.connectionParams.getUrl(), this.connectionParams.getUser(), this.connectionParams.getPassword());
            this.dbOpen = true;
            this.logger.debug("Connection to database at: {} established", (Object)this.connectionParams.getUrl());
        }
        catch (SQLRecoverableException _ex) {
            if (this.connectionRetries.incrementAndGet() > this.connectionParams.getMaxRetries()) {
                this.logger.error("Connection could not be established within {} attempts, url={}", (Object)this.connectionParams.getMaxRetries(), (Object)this.connectionParams.getUrl());
            } else {
                this.logger.error("Connection could not be established. Reconnection attempt #{} of {}, url={}, exception={}", new Object[]{this.connectionRetries.get(), this.connectionParams.getMaxRetries(), this.connectionParams.getUrl(), _ex.getMessage()});
                this.openConnection();
            }
        }
        catch (SQLException _ex) {
            this.logger.error("Database at [{}] could not be opened and offline cache was disabled.", (Object)this.connectionParams.getUrl());
            this.logger.debug("Exception was: ", (Throwable)_ex);
        }
    }

    public Connection getDbConnection() {
        return this.dbConnection;
    }

    public synchronized void closeDatabase() throws SQLException {
        if (this.dbConnection != null) {
            this.dbConnection.close();
        }
        this.dbOpen = false;
    }

    public synchronized boolean isDbOpen() {
        return this.dbOpen;
    }

    public synchronized boolean executeBatchQuery(String _sqlQuery, List<Object[]> _sqlParameters, int _batchSize) {
        if (this.dbConnection == null) {
            this.logger.error("Database connection for [{}] not established yet", (Object)this.connectionParams);
            return false;
        }
        if (_sqlParameters == null || _sqlParameters.isEmpty()) {
            return false;
        }
        if (this.isSupportsBatch()) {
            this.logger.debug("About to perform {} updates with batch size {}.", (Object)_sqlParameters.size(), (Object)_batchSize);
            List<List<Object[]>> splitList = TypeUtil.splitList(_sqlParameters, _batchSize);
            boolean hasError = false;
            try {
                for (List<Object[]> batchPart : splitList) {
                    PreparedStatement stmt = this.dbConnection.prepareStatement(_sqlQuery);
                    try {
                        for (Object[] sqlParams : batchPart) {
                            if (sqlParams == null) continue;
                            for (int i = 0; i < sqlParams.length; ++i) {
                                stmt.setObject(i + 1, sqlParams[i]);
                            }
                            stmt.addBatch();
                        }
                        int[] numUpdates = stmt.executeBatch();
                        for (int i = 0; i < numUpdates.length; ++i) {
                            if (numUpdates[i] == -2) {
                                this.logger.trace("Execution of batch {}: successful, but unknown number of rows affected", (Object)i);
                                continue;
                            }
                            if (numUpdates[i] == -3) {
                                this.logger.error("Execution of batch {}/{} failed, parms: {}", new Object[]{i, numUpdates.length, Arrays.toString(batchPart.get(i))});
                                hasError = true;
                                continue;
                            }
                            this.logger.trace("Execution of batch {} successful.", (Object)i);
                        }
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                return !hasError;
            }
            catch (SQLException _ex) {
                this.logger.error("Error while processing batch.", (Throwable)_ex);
                return false;
            }
        }
        this.logger.warn("Using serial insert/update as database implementation does not support batch update!");
        boolean hasError = false;
        for (Object[] args : _sqlParameters) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing query {} with arguments: {}", (Object)_sqlQuery, Arrays.asList(args));
            }
            if (this.executeQuery(_sqlQuery, args)) continue;
            hasError = true;
        }
        return !hasError;
    }

    public synchronized boolean executeQuery(String _sql, Object ... _args) {
        boolean bl;
        block11: {
            if (this.dbConnection == null) {
                this.logger.error("Database connection for [{}] not established yet", (Object)this.connectionParams);
                return false;
            }
            PreparedStatement ps = this.dbConnection.prepareStatement(_sql);
            try {
                if (_args != null) {
                    for (int i = 0; i < _args.length; ++i) {
                        ps.setObject(i + 1, _args[i]);
                    }
                }
                boolean bl2 = bl = !ps.execute();
                if (ps == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException _ex) {
                    this.logger.error("Failed to execute sql statement: " + _sql, (Throwable)_ex);
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    public synchronized List<Map<String, String>> executeSelectQuery(String _sql, Object ... _args) {
        if (this.dbConnection == null) {
            this.logger.error("Database connection for [{}] not established yet", (Object)this.connectionParams);
            return null;
        }
        ArrayList<Map<String, String>> queryResult = new ArrayList<Map<String, String>>();
        try (PreparedStatement ps = this.dbConnection.prepareStatement(_sql);){
            if (_args != null) {
                for (int i = 0; i < _args.length; ++i) {
                    ps.setObject(i + 1, _args[i]);
                }
            }
            try (ResultSet result = ps.executeQuery();){
                while (result.next()) {
                    TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                    for (int i = 0; i < result.getMetaData().getColumnCount(); ++i) {
                        String columnName = result.getMetaData().getColumnLabel(i + 1);
                        map.put(columnName, result.getString(i + 1));
                    }
                    queryResult.add(map);
                }
            }
        }
        catch (SQLException _ex) {
            this.logger.error("Failed to execute sql statement: " + _sql, (Throwable)_ex);
        }
        this.logger.debug("Query: '{}' returned {} rows with parms: {}", new Object[]{_sql, queryResult.size(), Arrays.toString(_args)});
        return queryResult;
    }

    public synchronized PreparedStatement createPreparedStatement(String _sql) {
        PreparedStatement ps;
        if (this.dbConnection == null || !this.isDbOpen()) {
            this.logger.error("Could not create prepared statement: database connection missing for [{}]", (Object)this.connectionParams);
            return null;
        }
        if (StringUtil.isBlank(_sql)) {
            this.logger.error("Could not create prepared statement: statement cannot be empty or null");
            return null;
        }
        try {
            ps = this.dbConnection.prepareStatement(_sql);
        }
        catch (SQLException _ex) {
            this.logger.error("Could not create prepared statement: ", (Throwable)_ex);
            return null;
        }
        return ps;
    }

    public synchronized boolean executeQuery(PreparedStatement _ps) {
        if (this.dbConnection == null) {
            this.logger.error("Database connection for [{}] not established yet", (Object)this.connectionParams);
            return false;
        }
        if (_ps == null) {
            this.logger.error("Statement should not be null!");
            return false;
        }
        try {
            return !_ps.execute();
        }
        catch (SQLException _ex) {
            this.logger.error("Failed to execute sql statement:", (Throwable)_ex);
            return false;
        }
    }

    public synchronized boolean isSupportsBatch() {
        return this.supportsBatch;
    }

    public void setAutoCommit(boolean _onOff) throws SQLException {
        if (this.dbConnection != null) {
            this.dbConnection.setAutoCommit(_onOff);
        }
    }

    public boolean isAutoCommit() throws SQLException {
        if (this.dbConnection != null) {
            return this.dbConnection.getAutoCommit();
        }
        return false;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[open=" + this.dbOpen + ", connectionParams=" + this.connectionParams + "]";
    }
}

