/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.imaging;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;

public abstract class AbstractImgHash {
    private static final ColorConvertOp COLOR_CONVERTER = new ColorConvertOp(ColorSpace.getInstance(1003), null);

    protected int[] createPixelArray(BufferedImage _image) {
        if (_image == null) {
            return null;
        }
        int[] result = new int[_image.getHeight() * _image.getWidth()];
        int c = 0;
        for (int y = 0; y < _image.getHeight(); ++y) {
            for (int x = 0; x < _image.getWidth(); ++x) {
                int clr = _image.getRGB(x, y);
                result[c++] = clr;
            }
        }
        return result;
    }

    protected double[][] createPixelArrayMatrix(BufferedImage _image) {
        if (_image == null) {
            return null;
        }
        double[][] result = new double[_image.getHeight()][_image.getWidth()];
        for (int y = 0; y < _image.getHeight(); ++y) {
            for (int x = 0; x < _image.getWidth(); ++x) {
                int clr = _image.getRGB(x, y);
                result[y][x] = clr;
            }
        }
        return result;
    }

    protected BufferedImage resizeAndGrayScale(int _width, int _height, BufferedImage _input) {
        if (_input == null) {
            return null;
        }
        BufferedImage scaledImage = new BufferedImage(_width, _height, 2);
        Graphics2D g = scaledImage.createGraphics();
        if (_input.getColorModel().hasAlpha()) {
            g.setComposite(AlphaComposite.Src);
        }
        g.drawImage(_input, 0, 0, _width, _height, null);
        g.dispose();
        COLOR_CONVERTER.filter(scaledImage, scaledImage);
        return scaledImage;
    }

    protected String bitmaskToHex(boolean[] bitMask, int _minLen) {
        long bitSetInt = 0L;
        for (int i = 0; i < bitMask.length; ++i) {
            bitSetInt = (bitSetInt | (long)(bitMask[i] ? 1 : 0)) << 1;
        }
        if (_minLen <= -1) {
            return String.format("%x", bitSetInt);
        }
        return String.format("%0" + _minLen + "x", bitSetInt);
    }
}

