/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexUtil {
    private static final Map<String, Pattern> CACHED_PATTERNS = new HashMap<String, Pattern>();

    private RegexUtil() {
    }

    public static String[] splitByRegex(String _input, String _regex) {
        return RegexUtil.splitByRegex(_input, _regex, 0);
    }

    public static String[] splitByRegex(String _input, String _regex, int _limit) {
        boolean smart;
        Objects.requireNonNull(_regex, "Regex required");
        if (_input == null) {
            return null;
        }
        char ch = '\u0000';
        boolean bl = smart = (_regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch = _regex.charAt(0)) == -1 || _regex.length() == 2 && _regex.charAt(0) == '\\' && ((ch = _regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff');
        if (smart) {
            return _input.split(_regex, _limit);
        }
        Pattern pattern = CACHED_PATTERNS.computeIfAbsent(_regex, x -> {
            if (_regex.length() == 2 && _regex.charAt(0) == '\\' || _regex.length() == 1 && _regex.charAt(0) == '\\') {
                return Pattern.compile(Pattern.quote(_regex));
            }
            return Pattern.compile(_regex);
        });
        return pattern.split(_input, _limit);
    }

    public static boolean regexMatches(String _input, String _regex) {
        StringUtil.requireNonBlank(_regex, "Regex required");
        if (_input == null) {
            return false;
        }
        Pattern pattern = CACHED_PATTERNS.computeIfAbsent(_regex, Pattern::compile);
        Matcher matcher = pattern.matcher(_input);
        return matcher.matches();
    }

    public static List<String> extractByRegex(String _input, String _regex) {
        return RegexUtil.extractByRegex(_input, _regex, 0);
    }

    public static List<String> extractByRegex(String _input, String _regex, int _limitResults) {
        StringUtil.requireNonBlank(_regex, "Regex required");
        if (_input == null) {
            return null;
        }
        Pattern pattern = CACHED_PATTERNS.computeIfAbsent(_regex, Pattern::compile);
        return RegexUtil.extractByRegex(_input, pattern, _limitResults);
    }

    public static List<String> extractByRegex(String _input, Pattern _pattern, int _limitResults) {
        Objects.requireNonNull(_pattern, "Pattern required");
        Matcher matcher = _pattern.matcher(_input);
        if (matcher.groupCount() == 0) {
            throw new IllegalArgumentException("Pattern requires at least one capturing group: " + _pattern);
        }
        ArrayList<String> results = new ArrayList<String>();
        block0: while (matcher.find()) {
            for (int i = 1; i < matcher.groupCount() + 1; ++i) {
                results.add(matcher.group(i));
                if (_limitResults > 0 && results.size() >= _limitResults) continue block0;
            }
        }
        return results;
    }

    public static String extractFirstByRegex(String _input, String _regex) {
        List<String> results = RegexUtil.extractByRegex(_input, _regex, 1);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    public static String extractFirstByRegex(String _input, Pattern _pattern) {
        List<String> results = RegexUtil.extractByRegex(_input, _pattern, 1);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }
}

