/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.DateUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DateUtilTest {
    DateUtilTest() {
    }

    @Test
    void testIsDateInRange() {
        LocalDate startRange = LocalDate.of(2020, 9, 28);
        LocalDate endRange = LocalDate.of(2020, 10, 2);
        Assertions.assertTrue((boolean)DateUtil.isDateBetween((LocalDate)startRange, (LocalDate)endRange, (LocalDate)LocalDate.of(2020, 9, 28)));
        Assertions.assertTrue((boolean)DateUtil.isDateBetween((LocalDate)startRange, (LocalDate)endRange, (LocalDate)LocalDate.of(2020, 9, 29)));
        Assertions.assertTrue((boolean)DateUtil.isDateBetween((LocalDate)startRange, (LocalDate)endRange, (LocalDate)LocalDate.of(2020, 9, 30)));
        Assertions.assertTrue((boolean)DateUtil.isDateBetween((LocalDate)startRange, (LocalDate)endRange, (LocalDate)LocalDate.of(2020, 10, 1)));
        Assertions.assertTrue((boolean)DateUtil.isDateBetween((LocalDate)startRange, (LocalDate)endRange, (LocalDate)LocalDate.of(2020, 10, 2)));
        Assertions.assertTrue((boolean)DateUtil.isDateBetween((LocalDate)LocalDate.of(2022, 5, 3), (LocalDate)LocalDate.of(2022, 5, 3), (LocalDate)LocalDate.of(2022, 5, 3)));
        Assertions.assertFalse((boolean)DateUtil.isDateBetween((LocalDate)startRange, (LocalDate)endRange, (LocalDate)LocalDate.of(2020, 9, 27)));
        Assertions.assertFalse((boolean)DateUtil.isDateBetween((LocalDate)startRange, (LocalDate)endRange, (LocalDate)LocalDate.of(2020, 10, 3)));
    }

    @DisplayName(value="Test LocalTime After/Equal")
    @ParameterizedTest
    @MethodSource(value={"createLocalTimeTestData"})
    void testTimeAfterEqual(DateTestData<LocalTime> _data) {
        Assertions.assertEquals((Object)_data.isResultAfter(), (Object)DateUtil.isAfterEqual((LocalTime)_data.getFirst(), (LocalTime)_data.getSecond()));
    }

    @DisplayName(value="Test LocalDate After/Equal")
    @ParameterizedTest
    @MethodSource(value={"createLocalDateTestData"})
    void testDateAfterEqual(DateTestData<LocalDate> _data) {
        Assertions.assertEquals((Object)_data.isResultAfter(), (Object)DateUtil.isAfterEqual((LocalDate)_data.getFirst(), (LocalDate)_data.getSecond()));
    }

    @DisplayName(value="Test LocalDateTime After/Equal")
    @ParameterizedTest
    @MethodSource(value={"createLocalDateTimeTestData"})
    void testDateTimeAfterEqual(DateTestData<LocalDateTime> _data) {
        Assertions.assertEquals((Object)_data.isResultAfter(), (Object)DateUtil.isAfterEqual((LocalDateTime)_data.getFirst(), (LocalDateTime)_data.getSecond()));
    }

    @DisplayName(value="Test LocalTime Before/Equal")
    @ParameterizedTest
    @MethodSource(value={"createLocalTimeTestData"})
    void testTimeBeforeEqual(DateTestData<LocalTime> _data) {
        Assertions.assertEquals((Object)_data.isResultBefore(), (Object)DateUtil.isBeforeEqual((LocalTime)_data.getFirst(), (LocalTime)_data.getSecond()));
    }

    @DisplayName(value="Test LocalDate Before/Equal")
    @ParameterizedTest
    @MethodSource(value={"createLocalDateTestData"})
    void testDateBeforeEqual(DateTestData<LocalDate> _data) {
        Assertions.assertEquals((Object)_data.isResultBefore(), (Object)DateUtil.isBeforeEqual((LocalDate)_data.getFirst(), (LocalDate)_data.getSecond()));
    }

    @DisplayName(value="Test LocalDateTime Before/Equal")
    @ParameterizedTest
    @MethodSource(value={"createLocalDateTimeTestData"})
    void testDateTimeBeforeEqual(DateTestData<LocalDateTime> _data) {
        Assertions.assertEquals((Object)_data.isResultBefore(), (Object)DateUtil.isBeforeEqual((LocalDateTime)_data.getFirst(), (LocalDateTime)_data.getSecond()));
    }

    static Stream<DateTestData<LocalTime>> createLocalTimeTestData() {
        return Stream.of(new DateTestData<LocalTime>(LocalTime.of(11, 11, 11), LocalTime.of(11, 11, 11), true, true), new DateTestData<LocalTime>(LocalTime.of(10, 11, 11), LocalTime.of(11, 11, 11), true, false), new DateTestData<LocalTime>(LocalTime.of(11, 11, 10), LocalTime.of(11, 11, 11), true, false), new DateTestData<LocalTime>(LocalTime.of(12, 11, 10), LocalTime.of(11, 11, 11), false, true), new DateTestData<LocalTime>(LocalTime.of(11, 11, 12), LocalTime.of(11, 11, 11), false, true));
    }

    static Stream<DateTestData<LocalDate>> createLocalDateTestData() {
        return Stream.of(new DateTestData<LocalDate>(LocalDate.of(2023, 11, 11), LocalDate.of(2023, 11, 11), true, true), new DateTestData<LocalDate>(LocalDate.of(2023, 10, 11), LocalDate.of(2023, 11, 11), true, false), new DateTestData<LocalDate>(LocalDate.of(2023, 11, 10), LocalDate.of(2023, 11, 11), true, false), new DateTestData<LocalDate>(LocalDate.of(2024, 11, 11), LocalDate.of(2023, 11, 11), false, true), new DateTestData<LocalDate>(LocalDate.of(2023, 11, 12), LocalDate.of(2023, 11, 11), false, true));
    }

    static Stream<DateTestData<LocalDateTime>> createLocalDateTimeTestData() {
        return Stream.of(new DateTestData<LocalDateTime>(LocalDateTime.of(2023, 11, 11, 1, 2, 3), LocalDateTime.of(2023, 11, 11, 1, 2, 3), true, true), new DateTestData<LocalDateTime>(LocalDateTime.of(2023, 10, 11, 1, 2, 2), LocalDateTime.of(2023, 11, 11, 1, 2, 3), true, false), new DateTestData<LocalDateTime>(LocalDateTime.of(2023, 11, 10, 1, 2, 3), LocalDateTime.of(2023, 11, 11, 1, 2, 3), true, false), new DateTestData<LocalDateTime>(LocalDateTime.of(2024, 11, 11, 1, 2, 3), LocalDateTime.of(2023, 11, 11, 1, 0, 0), false, true), new DateTestData<LocalDateTime>(LocalDateTime.of(2023, 11, 12, 11, 12, 13), LocalDateTime.of(2023, 11, 11, 1, 0, 0), false, true));
    }

    static class DateTestData<T extends Temporal> {
        private final T first;
        private final T second;
        private final boolean resultBefore;
        private final boolean resultAfter;

        DateTestData(T _first, T _second, boolean _resultBefore, boolean _resultAfter) {
            this.first = _first;
            this.second = _second;
            this.resultBefore = _resultBefore;
            this.resultAfter = _resultAfter;
        }

        T getFirst() {
            return this.first;
        }

        T getSecond() {
            return this.second;
        }

        boolean isResultBefore() {
            return this.resultBefore;
        }

        boolean isResultAfter() {
            return this.resultAfter;
        }

        public String toString() {
            return "[first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + ", resultBefore=" + this.resultBefore + ", resultAfter=" + this.resultAfter + "]";
        }
    }
}

