/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.NumberUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NumberUtilTest {
    NumberUtilTest() {
    }

    @Test
    void convertNumberToBigDecimal() {
        Double v = 11.111;
        BigDecimal bigDecimal = NumberUtil.convertNumberToBigDecimal((Number)v, (int)3);
        Assertions.assertEquals((Double)v, (double)bigDecimal.doubleValue());
        Assertions.assertEquals((int)3, (int)bigDecimal.scale());
    }

    @Test
    void testConvertNumberToBigDecimal() {
        BigInteger bigInteger = BigInteger.valueOf(100L);
        BigDecimal bigDecimal = NumberUtil.convertNumberToBigDecimal((Number)bigInteger);
        Assertions.assertEquals((Object)bigDecimal.toBigInteger(), (Object)bigInteger);
    }

    @Test
    void isLess() {
        Assertions.assertTrue((boolean)NumberUtil.isLess((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ONE));
    }

    @Test
    void isGreater() {
        Assertions.assertTrue((boolean)NumberUtil.isGreater((BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO));
    }

    @Test
    void isEqual() {
        Assertions.assertTrue((boolean)NumberUtil.isEqual((BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.valueOf(1L)));
        Assertions.assertTrue((boolean)NumberUtil.isEqual((BigDecimal)new BigDecimal("1.11000"), (BigDecimal)new BigDecimal("1.11")));
    }

    @Test
    void isZero() {
        Assertions.assertTrue((boolean)NumberUtil.isZero((BigDecimal)BigDecimal.ZERO));
        Assertions.assertFalse((boolean)NumberUtil.isZero((BigDecimal)BigDecimal.ONE));
    }

    @Test
    void isGreaterOrEqual() {
        Assertions.assertTrue((boolean)NumberUtil.isGreaterOrEqual((BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO));
        Assertions.assertTrue((boolean)NumberUtil.isGreaterOrEqual((BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ONE));
    }

    @Test
    void isLessOrEqual() {
        Assertions.assertTrue((boolean)NumberUtil.isLessOrEqual((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ONE));
        Assertions.assertTrue((boolean)NumberUtil.isLessOrEqual((BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ONE));
    }

    @Test
    void isNegative() {
        Assertions.assertTrue((boolean)NumberUtil.isNegative((BigDecimal)BigDecimal.valueOf(-1L)));
    }

    @Test
    void invert() {
        Assertions.assertEquals((Object)BigDecimal.ONE, (Object)NumberUtil.invert((BigDecimal)BigDecimal.valueOf(-1L)));
    }

    @Test
    void sumBigDecimals() {
        Assertions.assertEquals((Object)NumberUtil.sumBigDecimals((BigDecimal[])new BigDecimal[]{BigDecimal.ONE, BigDecimal.ONE}), (Object)BigDecimal.valueOf(2L));
    }

    @Test
    void testSumBigDecimals() {
        BigDecimal expected = BigDecimal.ONE.add(BigDecimal.TEN);
        Assertions.assertEquals((Object)expected, (Object)NumberUtil.sumBigDecimals((BigDecimal[])new BigDecimal[]{BigDecimal.ONE, BigDecimal.TEN}));
    }
}

