/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.util.TypeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.jupiter.api.Test;

public class TypeUtilTest
extends AbstractBaseUtilTest {
    @Test
    public void testCreateProperties() {
        Properties props = TypeUtil.createProperties((String[])null);
        TypeUtilTest.assertNotNull((Object)props);
        TypeUtilTest.assertEquals((int)0, (int)props.size());
        props = TypeUtil.createProperties((String[])new String[]{"k1", "v1", "k2", "v2"});
        TypeUtilTest.assertNotNull((Object)props);
        TypeUtilTest.assertEquals((int)2, (int)props.size());
        Exception ex = null;
        try {
            props = TypeUtil.createProperties((String[])new String[]{"k1"});
        }
        catch (Exception _ex) {
            ex = _ex;
        }
        TypeUtilTest.assertNotNull((Object)ex);
    }

    @Test
    public void testIsInteger() {
        System.out.println("isInteger");
        String int1 = "0";
        String int2 = "-148832";
        String int3 = "4711";
        String int4 = "0.815";
        String int5 = "no int";
        String int6 = null;
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isInteger((String)int1));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isInteger((String)int2, (boolean)false));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isInteger((String)int2));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isInteger((String)int3));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isInteger((String)int4));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isInteger((String)int5));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isInteger(int6));
    }

    @Test
    public void testIsDouble() {
        System.out.println("isDouble");
        String int1 = "0";
        String int2 = "-0.45";
        String int3 = "4.711";
        String int4 = "0,815";
        String int5 = "no double";
        String int6 = null;
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isDouble((String)int1, (char)'.'));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isDouble((String)int2, (char)'.', (boolean)false));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isDouble((String)int2, (char)'.'));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isDouble((String)int3, (char)'.'));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isDouble((String)int4, (char)'.'));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isDouble((String)int5, (char)'.'));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isDouble(int6, (char)'.'));
    }

    @Test
    public void testIsValidNetworkPort() {
        System.out.println("isValidNetworkPort");
        int int1 = 4711;
        int int2 = 100000;
        int int3 = -2003;
        int int4 = 113;
        String port1 = "19393";
        String port2 = "100032";
        String port3 = "-19432";
        String port4 = "80";
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isValidNetworkPort((int)int1, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((int)int2, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((int)int3, (boolean)true));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isValidNetworkPort((int)int4, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((int)int4, (boolean)false));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isValidNetworkPort((String)port1, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((String)port2, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((String)port3, (boolean)true));
        TypeUtilTest.assertEquals((Object)true, (Object)TypeUtil.isValidNetworkPort((String)port4, (boolean)true));
        TypeUtilTest.assertEquals((Object)false, (Object)TypeUtil.isValidNetworkPort((String)port4, (boolean)false));
    }

    @Test
    public void testCreateMap() throws Exception {
        Map map = TypeUtil.createMap((Object[])new String[]{"1", "a", "2", "b", "3", "c", "4", "d"});
        TypeUtilTest.assertMap(map, "1", "2", "3", "4");
        TypeUtilTest.assertEquals((int)4, (int)map.size());
        TypeUtilTest.assertEquals((Object)"a", map.get("1"));
        TypeUtilTest.assertTrue((boolean)map.containsKey("1"));
        TypeUtilTest.assertTrue((boolean)map.containsValue("a"));
    }

    @Test
    public void testCreateList() throws Exception {
        List list = TypeUtil.createList((Object[])new String[]{"u", "r", "gr8"});
        TypeUtilTest.assertCollection(list, "u", "r", "gr8");
        TypeUtilTest.assertNotNull((Object)TypeUtil.createList((Object[])new Object[0]));
        TypeUtilTest.assertNotNull((Object)TypeUtil.createList((Object[])null));
    }

    @Test
    public void testSplitListToSubLists() throws Exception {
        List list = TypeUtil.createList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        List listOf2 = TypeUtil.splitListToSubLists((List)list, (int)2);
        TypeUtilTest.assertNotNull((Object)listOf2);
        TypeUtilTest.assertEquals((int)2, (int)listOf2.size());
        TypeUtilTest.assertCollection((Collection)listOf2.get(0), 1, 2, 3, 4, 5);
        TypeUtilTest.assertCollection((Collection)listOf2.get(1), 6, 7, 8, 9, 10);
        List listOf5 = TypeUtil.splitListToSubLists((List)list, (int)5);
        TypeUtilTest.assertNotNull((Object)listOf5);
        TypeUtilTest.assertEquals((int)5, (int)listOf5.size());
        TypeUtilTest.assertCollection((Collection)listOf5.get(0), 1, 2);
        TypeUtilTest.assertCollection((Collection)listOf5.get(1), 3, 4);
        TypeUtilTest.assertCollection((Collection)listOf5.get(2), 5, 6);
        TypeUtilTest.assertCollection((Collection)listOf5.get(3), 7, 8);
        TypeUtilTest.assertCollection((Collection)listOf5.get(4), 9, 10);
        List listOf3 = TypeUtil.splitListToSubLists((List)list, (int)3);
        TypeUtilTest.assertNotNull((Object)listOf3);
        TypeUtilTest.assertEquals((int)3, (int)listOf3.size());
        TypeUtilTest.assertCollection((Collection)listOf3.get(0), 1, 2, 3);
        TypeUtilTest.assertCollection((Collection)listOf3.get(1), 4, 5, 6);
        TypeUtilTest.assertCollection((Collection)listOf3.get(2), 7, 8, 9, 10);
        list = TypeUtil.createList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        List list2Of9 = TypeUtil.splitListToSubLists((List)list, (int)2);
        TypeUtilTest.assertNotNull((Object)list2Of9);
        TypeUtilTest.assertEquals((int)2, (int)list2Of9.size());
        TypeUtilTest.assertCollection((Collection)list2Of9.get(0), 1, 2, 3, 4);
        TypeUtilTest.assertCollection((Collection)list2Of9.get(1), 5, 6, 7, 8, 9);
    }
}

