/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.config.xml;

import com.github.hypfvieh.util.ConverterUtil;
import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.TypeUtil;
import com.github.hypfvieh.util.xml.XmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XmlConfiguration {
    private Document xmlDocument;
    private OutputStream outputStream;
    private File outputFile;
    private String keyDelimiter = "/";
    private File inputFile;
    private InputStream inputStream;
    private ErrorHandler errorHandler;
    private boolean skipRootLevel;
    private boolean allowOverride;

    XmlConfiguration(boolean _skipRootLevel) {
        this.skipRootLevel = _skipRootLevel;
    }

    public String getKeyDelimiter() {
        return this.keyDelimiter;
    }

    public void setKeyDelimiter(String _keyDelimiter) {
        this.keyDelimiter = _keyDelimiter == null ? "/" : Pattern.quote(_keyDelimiter);
    }

    public int keyCount() {
        return this.countNodes(this.getXmlDocument());
    }

    public String getString(String _key) {
        return this.getString(_key, null);
    }

    public String getString(String _key, String _default) {
        String result = this.getStringFromEnv(_key);
        if (result == null) {
            String[] split = _key.split(this.keyDelimiter);
            Node node = this.findNode(split);
            if (node == null) {
                return _default;
            }
            if (node.getNodeName().equals(split[split.length - 1])) {
                result = node.getTextContent();
            } else if (XmlUtil.isElementType(node)) {
                result = XmlUtil.toElement(node).getAttribute(split[split.length - 1]);
            }
        }
        return result == null ? _default : result;
    }

    public int getInt(String _key, int _default) {
        String valAsStr = this.getString(_key, String.valueOf(_default));
        if (valAsStr == null || !TypeUtil.isInteger(valAsStr)) {
            return _default;
        }
        return Integer.parseInt(valAsStr);
    }

    public double getDouble(String _key, double _default) {
        String valAsStr = this.getString(_key, "" + _default);
        if (valAsStr == null || !TypeUtil.isDouble(valAsStr)) {
            return _default;
        }
        return Double.parseDouble(valAsStr);
    }

    public boolean getBoolean(String _key, boolean _default) {
        String valAsStr = this.getString(_key, String.valueOf(_default));
        if (StringUtil.isBlank(valAsStr)) {
            return _default;
        }
        return ConverterUtil.strToBool(valAsStr);
    }

    public void setString(String _key, boolean _asAttribute, String _value) {
        String[] split = _key.split(this.keyDelimiter);
        Node findNode = this.findNode(split);
        if (_asAttribute) {
            if (XmlUtil.isElementType(findNode)) {
                XmlUtil.toElement(findNode).setAttribute(split[split.length - 1], _value);
            }
        } else {
            findNode.setTextContent(_value);
        }
    }

    private List<String> getList(String _key) {
        Node findNode = this.findNode(_key.split(this.keyDelimiter));
        if (findNode == null) {
            return new ArrayList<String>();
        }
        String[] keys = null;
        if (!findNode.hasChildNodes() || findNode.getChildNodes().getLength() <= 1) {
            findNode = findNode.getParentNode();
            keys = _key.split(this.keyDelimiter);
        }
        ArrayList<String> values = new ArrayList<String>();
        NodeList childNodes = findNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (keys != null) {
                if (!childNodes.item(i).getNodeName().equals(keys[keys.length - 1])) continue;
                values.add(childNodes.item(i).getTextContent());
                continue;
            }
            if (!XmlUtil.isElementType(childNodes.item(i))) continue;
            values.add(childNodes.item(i).getTextContent());
        }
        return values;
    }

    public List<String> getStringList(String _key) {
        String str = this.getStringFromEnv(_key);
        if (str != null) {
            if (str.contains("~|~")) {
                return TypeUtil.createList(str.split("~\\|~"));
            }
            return TypeUtil.createList(str);
        }
        List<String> list = this.getList(_key);
        if (list == null) {
            return new ArrayList<String>();
        }
        return list;
    }

    public Set<String> getStringSet(String _key, Class<? extends Set> _setClass) {
        if (_setClass == null) {
            _setClass = TreeSet.class;
        }
        List<String> list = this.getStringList(_key);
        try {
            Set newInstance = _setClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            newInstance.addAll(list);
            return newInstance;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException _ex) {
            return new TreeSet<String>(list);
        }
    }

    public void setValues(Map<String, String> _values, boolean _asAttributes) {
        for (Map.Entry<String, String> entry : _values.entrySet()) {
            this.setString(entry.getKey(), _asAttributes, entry.getValue());
        }
    }

    public void save() throws IOException {
        ArrayList exception = new ArrayList();
        this.save((t, u) -> {
            try {
                XmlUtil.printDocument(t, u);
            }
            catch (IOException _ex) {
                exception.add(_ex);
            }
        });
        if (!exception.isEmpty()) {
            throw (IOException)exception.get(0);
        }
    }

    public void save(BiConsumer<Document, OutputStream> _outputGenerator) throws IOException {
        OutputStream output = null;
        if (this.outputStream != null) {
            output = this.outputStream;
        } else if (this.outputFile != null) {
            output = new FileOutputStream(this.outputFile, false);
        }
        if (output == null) {
            throw new IOException("No output stream or file given. Cannot save changes");
        }
        _outputGenerator.accept(this.xmlDocument, output);
    }

    public File getInputFile() {
        return this.inputFile;
    }

    void setInputFile(File _inputFile) {
        this.inputFile = _inputFile;
    }

    void setOutputFile(File _outputFile) {
        this.outputFile = _outputFile;
    }

    void setInputStream(InputStream _inputStream) {
        this.inputStream = _inputStream;
    }

    void setOutputStream(OutputStream _outputStream) {
        this.outputStream = _outputStream;
    }

    void setXmlErrorHandler(ErrorHandler _errorHandler) {
        this.errorHandler = _errorHandler;
    }

    void setAllowOverride(boolean _allowOverride) {
        this.allowOverride = _allowOverride;
    }

    void readAndValidate() throws IOException {
        Objects.requireNonNull(this.inputStream, "InputStream cannot be null");
        DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
        dbFac.setNamespaceAware(false);
        if (this.errorHandler != null) {
            dbFac.setValidating(true);
        }
        try {
            DocumentBuilder builder = dbFac.newDocumentBuilder();
            builder.setErrorHandler(this.errorHandler);
            this.xmlDocument = builder.parse(this.inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException _ex) {
            throw new IOException(_ex);
        }
    }

    private Node getXmlDocument() {
        if (this.skipRootLevel) {
            return this.xmlDocument.getDocumentElement();
        }
        return this.xmlDocument;
    }

    private Node findNode(String[] split) {
        if (split == null) {
            return null;
        }
        Node node = this.getXmlDocument();
        boolean found = false;
        block0: for (String k : split) {
            found = false;
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node item = node.getChildNodes().item(i);
                if (!item.getNodeName().equals(k)) continue;
                node = item;
                found = true;
                continue block0;
            }
        }
        return found ? node : null;
    }

    private int countNodes(Node _node) {
        if (_node == null) {
            return 0;
        }
        Node node = _node;
        int count = 0;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node item = node.getChildNodes().item(i);
            if (!XmlUtil.isElementType(item)) continue;
            ++count;
            if (!item.hasChildNodes()) continue;
            count += this.countNodes(item);
        }
        return count;
    }

    private String getStringFromEnv(String _key) {
        if (!this.allowOverride) {
            return null;
        }
        if (System.getProperties().containsKey(_key)) {
            String sysProp = System.getProperties().getProperty(_key);
            LoggerFactory.getLogger(this.getClass()).debug("Config-Property '{}' is overridden by environment variable, using value '{}'", (Object)_key, (Object)sysProp);
            return sysProp;
        }
        return null;
    }
}

