/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.files;

import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.SystemUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RollingFileUtil {
    public static File doFileRolling(File _fileToRollOver, String _pattern, int _maxFiles) throws IOException {
        if (_fileToRollOver == null || !_fileToRollOver.exists()) {
            throw new FileNotFoundException("Given file " + String.valueOf(_fileToRollOver) + " is invalid or does not exist");
        }
        RollingFileUtil util = new RollingFileUtil();
        util.validatePattern(_pattern);
        File checkAndMove = util.checkAndMove(_fileToRollOver, _pattern, _maxFiles);
        return checkAndMove;
    }

    private File renameFile(File _srcFile, File _targetFile) throws IOException {
        Files.move(_srcFile.toPath(), _targetFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        return _targetFile;
    }

    private File checkAndMove(File _fileToRollOver, String _filenamePattern, int _maxFiles) throws IOException {
        String baseFileName = this.expandFilePattern(_filenamePattern, _fileToRollOver.getName());
        int zeropad = _maxFiles / 10 + 1;
        LinkedHashMap<File, File> moveMap = new LinkedHashMap<File, File>();
        for (int i = 1; i < _maxFiles + 1; ++i) {
            File expectedFile = new File(_fileToRollOver.getParentFile(), baseFileName.replace("%{n}", String.format("%" + (String)(zeropad == 0 ? "d" : "0" + zeropad + "d"), i)));
            File newFileName = new File(_fileToRollOver.getParentFile(), baseFileName.replace("%{n}", String.format("%" + (String)(zeropad == 0 ? "d" : "0" + zeropad + "d"), i + 1)));
            if (i + 1 > _maxFiles) {
                newFileName = null;
            }
            moveMap.put(expectedFile, newFileName);
        }
        ArrayList mapKeys = new ArrayList(moveMap.keySet());
        Collections.reverse(mapKeys);
        File firstFile = (File)mapKeys.get(mapKeys.size() - 1);
        if (!firstFile.exists()) {
            this.renameFile(_fileToRollOver, firstFile);
            return firstFile;
        }
        for (File k : mapKeys) {
            if (!k.exists()) {
                moveMap.remove(k);
                continue;
            }
            File fileInMap = (File)moveMap.get(k);
            if (fileInMap == null) {
                moveMap.remove(k);
                k.delete();
                continue;
            }
            if (!k.exists() || fileInMap.exists()) continue;
            this.renameFile(k, fileInMap);
            moveMap.remove(k);
        }
        if (moveMap.isEmpty()) {
            return this.checkAndMove(_fileToRollOver, _filenamePattern, _maxFiles);
        }
        if (moveMap.size() > 1) {
            throw new IllegalStateException("Map should only contain one entry at this point");
        }
        return this.renameFile(_fileToRollOver, (File)moveMap.get(new ArrayList(moveMap.keySet()).get(0)));
    }

    private String expandFilePattern(String _pattern, String _origFilename) {
        String filePattern = _pattern;
        Pattern datePattern = Pattern.compile("%\\{date:([^\\}]+)\\}");
        Matcher matcher = datePattern.matcher(filePattern);
        while (matcher.find()) {
            String date;
            String javaDatePattern = matcher.group(1);
            try {
                date = DateTimeFormatter.ofPattern(javaDatePattern).format(LocalDateTime.now());
            }
            catch (Exception _ex) {
                throw new IllegalArgumentException("Given date format is not a valid java DateTimeFormatter format!", _ex);
            }
            filePattern = filePattern.replaceFirst("%\\{date:" + javaDatePattern + "\\}", date);
        }
        String fileExtension = SystemUtil.getFileExtension(_origFilename);
        filePattern = filePattern.replace("%{ext}", fileExtension);
        return filePattern;
    }

    private void validatePattern(String _pattern) {
        if (_pattern == null) {
            throw new IllegalArgumentException("No filename pattern provided");
        }
        if (StringUtil.isBlank(_pattern)) {
            throw new IllegalArgumentException("Invalid filename pattern provided");
        }
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = _pattern.indexOf("%{n}", lastIndex)) == -1) continue;
            ++count;
            lastIndex += "%{n}".length();
        }
        if (count > 1) {
            throw new IllegalArgumentException("Placeholder %{n} can only be used once");
        }
        if (count == 0) {
            throw new IllegalArgumentException("Usage of placeholder %{n} is always required");
        }
    }
}

