/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.formatter;

import com.github.hypfvieh.formatter.StringSplitOperator;
import com.github.hypfvieh.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TableColumnFormatter {
    private final int[] columnWidths;
    private final StringSplitOperator splitOperator;
    private final String padChar;

    public TableColumnFormatter(StringSplitOperator _splitOperator, char _padChar, int ... _columnWidths) {
        if (_splitOperator == null) {
            throw new NullPointerException("Split operator required");
        }
        if (_columnWidths == null || _columnWidths.length == 0) {
            throw new IllegalArgumentException("Array of column widths required");
        }
        for (int i = 0; i < _columnWidths.length; ++i) {
            if (_columnWidths[i] >= 1) continue;
            throw new IllegalArgumentException("Invalid column width at index " + i);
        }
        this.splitOperator = _splitOperator;
        this.padChar = String.valueOf(_padChar);
        this.columnWidths = _columnWidths;
    }

    public TableColumnFormatter(StringSplitOperator _splitOperator, int ... _columnWidths) {
        this(_splitOperator, ' ', _columnWidths);
    }

    public String formatLine(String ... _columnContent) {
        if (_columnContent == null || _columnContent.length == 0) {
            _columnContent = new String[]{null};
        } else if (_columnContent.length > this.columnWidths.length) {
            throw new IllegalArgumentException("Expected max " + this.columnWidths.length + " columns but got " + _columnContent.length);
        }
        ArrayList<List<String>> allTokens = new ArrayList<List<String>>();
        int maxLines = 1;
        for (int colIdx = 0; colIdx < this.columnWidths.length; ++colIdx) {
            int colWidth = this.columnWidths[colIdx];
            if (colIdx < _columnContent.length) {
                List<String> tokens = this.splitOperator.applySplit(_columnContent[colIdx], colWidth);
                if (tokens == null) {
                    tokens = new ArrayList<String>();
                }
                for (int lineIdx = 0; lineIdx < tokens.size(); ++lineIdx) {
                    tokens.set(lineIdx, StringUtil.rightPad(tokens.get(lineIdx), colWidth, this.padChar));
                }
                maxLines = Math.max(maxLines, tokens.size());
                allTokens.add(colIdx, tokens);
                continue;
            }
            allTokens.add(colIdx, Arrays.asList(StringUtil.repeat(this.padChar, colWidth)));
        }
        StringBuilder sb = new StringBuilder();
        for (int lineIdx = 0; lineIdx < maxLines; ++lineIdx) {
            if (sb.length() > 0) {
                sb.append(System.lineSeparator());
            }
            for (int colIdx = 0; colIdx < this.columnWidths.length; ++colIdx) {
                List tokens = (List)allTokens.get(colIdx);
                if (lineIdx < tokens.size()) {
                    sb.append((String)tokens.get(lineIdx));
                } else {
                    sb.append(StringUtil.repeat(this.padChar, this.columnWidths[colIdx]));
                }
                if (colIdx >= this.columnWidths.length - 1) continue;
                sb.append(this.padChar);
            }
        }
        return sb.toString();
    }

    public String fillLine(char _char) {
        int totalWidth = 0;
        for (int colIdx = 0; colIdx < this.columnWidths.length; ++colIdx) {
            totalWidth += this.columnWidths[colIdx];
        }
        return StringUtil.repeat(String.valueOf(_char), totalWidth += this.columnWidths.length - 1);
    }
}

