/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.imaging;

import com.github.hypfvieh.imaging.IImgHash;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

public class ImageCompare {
    public static int compareWith(IImgHash _hasher, File _img1, File _img2) {
        Objects.requireNonNull(_hasher);
        Objects.requireNonNull(_img1);
        Objects.requireNonNull(_img2);
        try {
            String img1Hash = _hasher.computeHash(_img1);
            String img2Hash = _hasher.computeHash(_img2);
            return ImageCompare.calcHammingDistance(img1Hash, img2Hash);
        }
        catch (IOException _ex) {
            throw new UncheckedIOException(_ex);
        }
    }

    public static int calcHammingDistance(String _left, String _right) {
        Objects.requireNonNull(_left, "Left string should not be null");
        Objects.requireNonNull(_right, "Right string should not be null");
        if (_left.length() != _right.length()) {
            throw new IllegalArgumentException("Strings must have the same length (left: " + _left.length() + ", right: " + _right.length() + ")");
        }
        int distance = 0;
        for (int i = 0; i < _left.length(); ++i) {
            if (_left.charAt(i) == _right.charAt(i)) continue;
            ++distance;
        }
        return distance;
    }
}

