/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.imaging;

import com.github.hypfvieh.imaging.AbstractImgHash;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImgPHash
extends AbstractImgHash {
    private static final int REGULAR_SIZE = 32;
    private static final int SMALL_SIZE = 8;
    private static double[] COEFFICIENTS = ImgPHash.initCoefficients(32);
    private static final ImgPHash INSTANCE = new ImgPHash();

    private ImgPHash() {
    }

    private static double[] initCoefficients(int _size) {
        double[] coeffi = new double[_size];
        for (int i = 1; i < _size; ++i) {
            coeffi[i] = 1.0;
        }
        coeffi[0] = 1.0 / Math.sqrt(2.0);
        return coeffi;
    }

    private double[][] applyDCT(double[][] f) {
        int nSize = 32;
        double[][] result = new double[nSize][nSize];
        for (int u = 0; u < nSize; ++u) {
            for (int v = 0; v < nSize; ++v) {
                double sum = 0.0;
                for (int i = 0; i < nSize; ++i) {
                    for (int j = 0; j < nSize; ++j) {
                        sum += Math.cos((double)(2 * i + 1) / (2.0 * (double)nSize) * (double)u * Math.PI) * Math.cos((double)(2 * j + 1) / (2.0 * (double)nSize) * (double)v * Math.PI) * f[i][j];
                    }
                }
                result[u][v] = sum *= COEFFICIENTS[u] * COEFFICIENTS[v] / 4.0;
            }
        }
        return result;
    }

    public static String computeHash(File _image) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(_image);
        BufferedImage resizedImage = INSTANCE.resizeAndGrayScale(32, 32, bufferedImage);
        return INSTANCE.hash(resizedImage);
    }

    private String hash(BufferedImage _resizedImg) {
        double[][] vals = new double[32][32];
        for (int x = 0; x < _resizedImg.getWidth(); ++x) {
            for (int y = 0; y < _resizedImg.getHeight(); ++y) {
                vals[x][y] = _resizedImg.getRGB(x, y);
            }
        }
        double[][] dctVals = this.applyDCT(vals);
        double total = 0.0;
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                total += dctVals[x][y];
            }
        }
        double avg = (total -= dctVals[0][0]) / 63.0;
        boolean[] bitMask = new boolean[64];
        int c = 0;
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                if (x == 0 || y == 0) continue;
                bitMask[c++] = dctVals[x][y] > avg;
            }
        }
        return this.bitmaskToHex(bitMask, 16);
    }
}

