/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public final class NumberUtil {
    public static final int BIGDECIMAL_DEFAULT_FRACTIONS = 15;
    public static final BigDecimal NEGATIVE_ONE = new BigDecimal(-1);
    public static final BigDecimal ONE_HUNDRED = new BigDecimal(100);

    private NumberUtil() {
    }

    public static BigDecimal convertNumberToBigDecimal(Number _num) {
        return NumberUtil.convertNumberToBigDecimal(_num, 15);
    }

    public static BigDecimal convertNumberToBigDecimal(Number _num, int _fractionDigits) {
        if (_num == null) {
            return null;
        }
        return new BigDecimal(_num.toString()).setScale(_fractionDigits, RoundingMode.HALF_UP);
    }

    public static boolean isLess(BigDecimal _v1, BigDecimal _v2) {
        if (_v1 == null || _v2 == null) {
            return false;
        }
        return _v1.compareTo(_v2) == -1;
    }

    public static boolean isGreater(BigDecimal _v1, BigDecimal _v2) {
        if (_v1 == null || _v2 == null) {
            return false;
        }
        return _v1.compareTo(_v2) == 1;
    }

    public static boolean isEqual(BigDecimal _v1, BigDecimal _v2) {
        if (_v1 == null || _v2 == null) {
            return false;
        }
        return _v1.compareTo(_v2) == 0;
    }

    public static boolean isZero(BigDecimal _val) {
        return NumberUtil.isEqual(_val, BigDecimal.ZERO);
    }

    public static boolean isGreaterOrEqual(BigDecimal _v1, BigDecimal _v2) {
        if (_v1 == null || _v2 == null) {
            return false;
        }
        return NumberUtil.isGreater(_v1, _v2) || NumberUtil.isEqual(_v1, _v2);
    }

    public static boolean isLessOrEqual(BigDecimal _v1, BigDecimal _v2) {
        if (_v1 == null || _v2 == null) {
            return false;
        }
        return NumberUtil.isLess(_v1, _v2) || NumberUtil.isEqual(_v1, _v2);
    }

    public static boolean isNegative(BigDecimal _bd) {
        if (_bd == null) {
            return false;
        }
        return _bd.signum() == -1;
    }

    public static BigDecimal invert(BigDecimal _bd) {
        if (_bd == null) {
            return null;
        }
        return _bd.multiply(NEGATIVE_ONE);
    }

    public static BigDecimal sumBigDecimals(BigDecimal ... _add) {
        if (_add == null || _add.length == 0) {
            return BigDecimal.ZERO;
        }
        return NumberUtil.sumBigDecimals(Arrays.asList(_add));
    }

    public static BigDecimal sumBigDecimals(Collection<BigDecimal> _add) {
        return _add == null ? BigDecimal.ZERO : _add.stream().filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

