/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    static <T extends Member> Set<T> getAllDeclared(Class<?> _clazz, Class<T> _type) {
        if (_type != Field.class && _type != Method.class) {
            return new LinkedHashSet();
        }
        LinkedHashSet<Member> l = new LinkedHashSet<Member>();
        try {
            Method method = _type == Method.class ? Class.class.getDeclaredMethod("getDeclaredMethods", new Class[0]) : Class.class.getDeclaredMethod("getDeclaredFields", new Class[0]);
            if (_clazz != null) {
                List<Member> entriesInThisClass = Arrays.asList((Member[])method.invoke(_clazz, new Object[0]));
                l.addAll(entriesInThisClass);
                if (_clazz.getSuperclass() != null) {
                    l.addAll(ReflectionUtil.getAllDeclared(_clazz.getSuperclass(), _type));
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException _ex) {
            return new LinkedHashSet();
        }
        return l;
    }

    public static Set<Field> getAllDeclaredFields(Class<?> _class, String ... _fieldsToIgnore) {
        if (_class == null) {
            return null;
        }
        List<String> fieldsToIgnore = Arrays.asList(_fieldsToIgnore);
        Set<Field> allDeclared = ReflectionUtil.getAllDeclared(_class, Field.class);
        return allDeclared.stream().filter(f -> !fieldsToIgnore.contains(f.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Field> getAllDeclaredStaticFields(Class<?> _class, String ... _fieldsToIgnore) {
        return ReflectionUtil.getAllDeclaredStatic(ReflectionType.FIELD, _class, _fieldsToIgnore);
    }

    public static Set<Field> getAllDeclaredNonStaticFields(Class<?> _class, String ... _fieldsToIgnore) {
        return ReflectionUtil.getAllDeclaredNonStatic(ReflectionType.FIELD, _class, _fieldsToIgnore);
    }

    @SafeVarargs
    public static Set<Field> getAllDeclaredFieldsAnnotatedWithAny(Class<?> _class, Class<? extends Annotation> ... _annotations) {
        return ReflectionUtil.getAllDeclaredWithAnnotationAction(ReflectionType.FIELD, _class, (f, a) -> f.isAnnotationPresent((Class<? extends Annotation>)a), _annotations);
    }

    @SafeVarargs
    public static Set<Field> getAllDeclaredFieldsNotAnnotatedWithAny(Class<?> _class, Class<? extends Annotation> ... _annotations) {
        return ReflectionUtil.getAllDeclaredWithAnnotationAction(ReflectionType.FIELD, _class, (f, a) -> !f.isAnnotationPresent((Class<? extends Annotation>)a), _annotations);
    }

    public static Set<Method> getAllDeclaredMethods(Class<?> _class, String ... _methodsToIgnore) {
        if (_class == null) {
            return null;
        }
        List<String> methodsToIgnore = Arrays.asList(_methodsToIgnore);
        Set<Method> allDeclared = ReflectionUtil.getAllDeclared(_class, Method.class);
        return allDeclared.stream().filter(f -> !methodsToIgnore.contains(f.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Method> getAllDeclaredStaticMethods(Class<?> _class, String ... _methodNamesToIgnore) {
        return ReflectionUtil.getAllDeclaredStatic(ReflectionType.METHOD, _class, _methodNamesToIgnore);
    }

    public static Set<Method> getAllDeclaredNonStaticMethods(Class<?> _class, String ... _methodNamesToIgnore) {
        return ReflectionUtil.getAllDeclaredNonStatic(ReflectionType.METHOD, _class, _methodNamesToIgnore);
    }

    @SafeVarargs
    public static Set<Method> getAllDeclaredMethodsAnnotatedWithAny(Class<?> _class, Class<? extends Annotation> ... _annotations) {
        return ReflectionUtil.getAllDeclaredWithAnnotationAction(ReflectionType.METHOD, _class, (f, a) -> f.isAnnotationPresent((Class<? extends Annotation>)a), _annotations);
    }

    @SafeVarargs
    public static Set<Method> getAllDeclaredMethodsNotAnnotatedWithAny(Class<?> _class, Class<? extends Annotation> ... _annotations) {
        return ReflectionUtil.getAllDeclaredWithAnnotationAction(ReflectionType.METHOD, _class, (f, a) -> !f.isAnnotationPresent((Class<? extends Annotation>)a), _annotations);
    }

    public static <T> T createInstance(Class<T> _clz) {
        if (_clz == null) {
            return null;
        }
        try {
            return _clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception _ex) {
            return null;
        }
    }

    private static <T extends Member> Set<T> getAllDeclaredStatic(ReflectionType _type, Class<?> _class, String ... _ignoreNames) {
        Set<? extends Member> allDeclaredFields = ReflectionUtil.getAllDeclared(_class, _type.getReflectionClass());
        List<String> ignoreNames = Arrays.asList(_ignoreNames);
        return allDeclaredFields.stream().filter(f -> !ignoreNames.contains(f.getName())).filter(f -> Modifier.isStatic(f.getModifiers())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static <T extends Member> Set<T> getAllDeclaredNonStatic(ReflectionType _type, Class<?> _class, String ... _ignoreNames) {
        Set<? extends Member> allDeclaredFields = ReflectionUtil.getAllDeclared(_class, _type.getReflectionClass());
        List<String> ignoreNames = Arrays.asList(_ignoreNames);
        return allDeclaredFields.stream().filter(f -> !ignoreNames.contains(f.getName())).filter(f -> !Modifier.isStatic(f.getModifiers())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @SafeVarargs
    private static <T> Set<T> getAllDeclaredWithAnnotationAction(ReflectionType _type, Class<?> _class, BiPredicate<T, Class<? extends Annotation>> _annotationCheckLambda, Class<? extends Annotation> ... _annotations) {
        if (_class == null) {
            return null;
        }
        if (_annotations == null || _annotations.length == 0) {
            return new LinkedHashSet();
        }
        Set<? extends Member> allDeclaredFields = ReflectionUtil.getAllDeclared(_class, _type.getReflectionClass());
        LinkedHashSet<Member> result = new LinkedHashSet<Member>();
        block0: for (Member member : allDeclaredFields) {
            for (Class<? extends Annotation> annot : _annotations) {
                if (!_annotationCheckLambda.test(member, annot)) continue;
                result.add(member);
                continue block0;
            }
        }
        return result;
    }

    public static enum ReflectionType {
        FIELD(Field.class),
        METHOD(Method.class);

        private final Class<? extends Member> reflectionClass;

        private ReflectionType(Class<? extends Member> _class) {
            this.reflectionClass = _class;
        }

        public Class<? extends Member> getReflectionClass() {
            return this.reflectionClass;
        }
    }
}

