/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.SystemUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslTlsUtil {
    private static final String STORETYPE_JCEKS = "jceks";
    private static final String STORETYPE_JKS = "jks";
    private static final String STORETYPE_PKCS12 = "pkcs12";
    private static final String STORETYPE_DER_ENCODED = "cer";
    private static final Logger LOGGER = LoggerFactory.getLogger(SslTlsUtil.class);

    private SslTlsUtil() {
    }

    public static TrustManager[] initializeTrustManagers(File _trustStoreFile, String _trustStorePassword) throws IOException {
        boolean derEncoded;
        if (_trustStoreFile == null) {
            return null;
        }
        String storeType = SslTlsUtil.getStoreTypeByFileName(_trustStoreFile);
        boolean bl = derEncoded = storeType == STORETYPE_DER_ENCODED;
        if (derEncoded) {
            storeType = STORETYPE_JKS;
        }
        String trustStorePwd = StringUtil.defaultIfBlank(_trustStorePassword, System.getProperty("javax.net.ssl.trustStorePassword"));
        LOGGER.debug("Creating trust store of type '{}' from {} file '{}'", new Object[]{storeType, derEncoded ? "DER-encoded" : "", _trustStoreFile});
        try {
            TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance(storeType);
            if (derEncoded) {
                FileInputStream fis = new FileInputStream(_trustStoreFile);
                X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(fis);
                trustStore.load(null, null);
                trustStore.setCertificateEntry("[der_cert_alias]", certificate);
            } else {
                trustStore.load(new FileInputStream(_trustStoreFile), trustStorePwd != null ? trustStorePwd.toCharArray() : null);
            }
            trustMgrFactory.init(trustStore);
            return trustMgrFactory.getTrustManagers();
        }
        catch (GeneralSecurityException _ex) {
            throw new IOException("Error while setting up trustStore", _ex);
        }
    }

    public static KeyManager[] initializeKeyManagers(File _keyStoreFile, String _keyStorePassword, String _keyPassword) throws IOException {
        String keyPwd;
        if (_keyStoreFile == null) {
            return null;
        }
        String keyStorePwd = StringUtil.defaultIfBlank(_keyStorePassword, System.getProperty("javax.net.ssl.keyStorePassword"));
        if (StringUtil.isBlank(keyStorePwd)) {
            keyStorePwd = "changeit";
        }
        if (StringUtil.isBlank(keyPwd = StringUtil.defaultIfBlank(_keyPassword, System.getProperty("javax.net.ssl.keyStorePassword")))) {
            keyPwd = "changeit";
        }
        String storeType = SslTlsUtil.getStoreTypeByFileName(_keyStoreFile);
        LOGGER.debug("Creating key store of type '{}' from file '{}'", (Object)storeType, (Object)_keyStoreFile);
        try {
            KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance(storeType);
            try (FileInputStream fis = new FileInputStream(_keyStoreFile);){
                keyStore.load(fis, keyStorePwd.toCharArray());
            }
            keyMgrFactory.init(keyStore, keyPwd.toCharArray());
            return keyMgrFactory.getKeyManagers();
        }
        catch (Exception _ex) {
            throw new IOException("Error while setting up keyStore", _ex);
        }
    }

    public static String getStoreTypeByFileName(File _file) {
        String ext;
        switch (ext = SystemUtil.getFileExtension(_file.getName()).toLowerCase()) {
            case "jks": 
            case "pkcs12": 
            case "cer": 
            case "jceks": {
                return ext;
            }
        }
        return STORETYPE_JKS;
    }
}

