/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class TimeMeasure {
    private static final long MILLIS_TO_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private volatile long startTime;

    public TimeMeasure() {
        this.reset();
    }

    TimeMeasure(long _startTime) {
        this.startTime = _startTime;
    }

    public TimeMeasure reset() {
        this.startTime = System.nanoTime();
        return this;
    }

    public long getElapsedMillis() {
        return this.getElapsedNanos() / MILLIS_TO_NANOS;
    }

    public long getElapsedNanos() {
        return System.nanoTime() - this.startTime;
    }

    public long getElapsedSeconds() {
        return TimeUnit.NANOSECONDS.toSeconds(this.getElapsedNanos());
    }

    public double getElapsedMinutes() {
        return (double)TimeUnit.NANOSECONDS.toSeconds(this.getElapsedNanos()) / 60.0;
    }

    public String getElapsedFormatted() {
        return TimeMeasure.formatDuration((double)this.getElapsedNanos() / (double)MILLIS_TO_NANOS);
    }

    public long getElapsedAndReset() {
        long elapsed = this.getElapsedMillis();
        this.reset();
        return elapsed;
    }

    public static String formatDuration(double _millis) {
        return TimeMeasure.formatDuration(_millis, Locale.getDefault());
    }

    static String formatDuration(double _millis, Locale _locale) {
        if (_millis < 1000.0) {
            return String.format(_locale, "%.2f ms", _millis);
        }
        if (_millis < 10000.0) {
            return String.format(_locale, "%d ms", (long)_millis);
        }
        long seconds = (long)(_millis / 1000.0);
        if (seconds < 300L) {
            return seconds + " seconds";
        }
        long minutes = TimeUnit.SECONDS.toMinutes(seconds);
        if (minutes < 60L) {
            return minutes + " minutes";
        }
        Duration dur = Duration.ofMillis((long)_millis);
        return String.format("%02d:%02d:%02d", dur.toHoursPart(), dur.toMinutesPart(), dur.toSecondsPart());
    }

    public String toString() {
        return this.getElapsedFormatted();
    }
}

