/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh;

import com.github.hypfvieh.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseUtilTest
extends Assertions {
    private Logger logger;
    private TestInfo lastTestInfo;

    protected final Logger getLogger() {
        if (null == this.logger) {
            this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    protected final void setLogger(String _loggerName) {
        this.logger = LoggerFactory.getLogger((String)Objects.requireNonNull(_loggerName, "Logger name required"));
    }

    @BeforeEach
    public final void setTestMethodName(TestInfo _testInfo) {
        this.lastTestInfo = _testInfo;
    }

    protected final String getTestMethodName() {
        if (this.lastTestInfo != null && this.lastTestInfo.getTestClass().isPresent()) {
            return ((Class)this.lastTestInfo.getTestClass().get()).getName() + "." + ((Method)this.lastTestInfo.getTestMethod().get()).getName();
        }
        return null;
    }

    protected final String getShortTestMethodName() {
        Optional testMethod = this.lastTestInfo == null ? Optional.empty() : this.lastTestInfo.getTestMethod();
        return testMethod.map(Method::getName).orElse(null);
    }

    @BeforeEach
    public final void logTestBegin(TestInfo _testInfo) {
        this.logTestBeginEnd("BGN", _testInfo);
    }

    @AfterEach
    public final void logTestEnd(TestInfo _testInfo) {
        this.logTestBeginEnd("END", _testInfo);
    }

    protected void logTestBeginEnd(String _prefix, TestInfo _testInfo) {
        if (!_testInfo.getTestMethod().isPresent() || _testInfo.getDisplayName().startsWith(((Method)_testInfo.getTestMethod().get()).getName())) {
            this.getLogger().info(">>>>>>>>>> {} Test: {} <<<<<<<<<<", (Object)_prefix, (Object)_testInfo.getDisplayName());
        } else {
            this.getLogger().info(">>>>>>>>>> {} Test: {} ({}) <<<<<<<<<<", new Object[]{_prefix, ((Method)_testInfo.getTestMethod().get()).getName(), _testInfo.getDisplayName()});
        }
    }

    private static String getStackTraceString(int _index) {
        StackTraceElement[] arrStackTraceElems = new Throwable().fillInStackTrace().getStackTrace();
        int lIndex = Math.min(arrStackTraceElems.length - 1, Math.max(0, _index));
        return arrStackTraceElems[lIndex].getClassName() + "." + arrStackTraceElems[lIndex].getMethodName();
    }

    public static String getMethodName() {
        return AbstractBaseUtilTest.getStackTraceString(2);
    }

    public static String getCallingMethodName() {
        return AbstractBaseUtilTest.getStackTraceString(3);
    }

    private static String getExceptionAsString(Throwable _ex) {
        if (_ex == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (_ex.getStackTrace() == null) {
            _ex.fillInStackTrace();
        }
        _ex.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    public static void assertNotEquals(Object _obj1, Object _obj2) {
        AbstractBaseUtilTest.assertFalse((boolean)Objects.equals(_obj1, _obj2), (String)("Parameters are equal: " + String.valueOf(_obj1) + " = " + String.valueOf(_obj2)));
    }

    public static void assertEmpty(String _string) {
        AbstractBaseUtilTest.assertTrue((boolean)(_string != null ? _string.isEmpty() : false), (String)"String not empty.");
    }

    public static void assertNotEmpty(String _string) {
        AbstractBaseUtilTest.assertTrue((boolean)(_string != null ? _string.isEmpty() : true), (String)"String is empty.");
    }

    public static void assertBlank(String _string) {
        AbstractBaseUtilTest.assertTrue((boolean)StringUtil.isBlank((CharSequence)_string), (String)"String not blank.");
    }

    public static void assertNotBlank(String _string) {
        AbstractBaseUtilTest.assertTrue((!StringUtil.isBlank((CharSequence)_string) ? 1 : 0) != 0, (String)"String is blank.");
    }

    public static void assertContains(String _string, String _contains) {
        if (_contains != null) {
            AbstractBaseUtilTest.assertTrue((boolean)(_string != null ? _string.contains(_contains) : false), (String)("String does not contain [" + _contains + "]: " + _string));
        }
    }

    public static void assertContainsNot(String _string, String _notContains) {
        if (_notContains != null) {
            AbstractBaseUtilTest.assertFalse((boolean)(_string != null ? _string.contains(_notContains) : true), (String)("String contains [" + _notContains + "]: " + _string));
        }
    }

    public static void assertDoubleEquals(double _expected, double _actual) {
        AbstractBaseUtilTest.assertEquals((double)_expected, (double)_actual, (double)1.0E-6);
    }

    public static void assertFail(String _message, Throwable _ex) {
        Object message = StringUtil.defaultIfBlank((String)_message, (String)("!no fail message provided by " + AbstractBaseUtilTest.getCallingMethodName()));
        if (_ex != null) {
            message = (String)message + " " + AbstractBaseUtilTest.getExceptionAsString(_ex);
        }
        AbstractBaseUtilTest.fail((String)message);
    }

    public static void assertFail(String _message) {
        AbstractBaseUtilTest.assertFail(_message, null);
    }

    public static final File assertFileExists(File _file) {
        return AbstractBaseUtilTest.assertFileExists(_file, true);
    }

    public static final File assertFileNotExists(File _file) {
        return AbstractBaseUtilTest.assertFileExists(_file, false);
    }

    private static File assertFileExists(File _file, boolean _exists) {
        AbstractBaseUtilTest.assertNotNull((Object)_file, (String)"File object is null.");
        if (_exists) {
            AbstractBaseUtilTest.assertTrue((boolean)_file.exists(), (String)("File [" + _file.getAbsolutePath() + "] does not exist."));
        } else {
            AbstractBaseUtilTest.assertTrue((!_file.exists() ? 1 : 0) != 0, (String)("File [" + _file.getAbsolutePath() + "] exists."));
        }
        return _file;
    }

    public static final File assertFileExists(String _file) {
        AbstractBaseUtilTest.assertNotNull((Object)_file);
        return AbstractBaseUtilTest.assertFileExists(new File(_file));
    }

    public static final String assertEnvSet(String _name) {
        AbstractBaseUtilTest.assertNotNull((Object)_name);
        String value = System.getenv(_name);
        AbstractBaseUtilTest.assertNotEmpty(value);
        return value;
    }

    @SafeVarargs
    public static final <K, V> Map<K, V> assertMap(Map<K, V> _map, K ... _keys) {
        AbstractBaseUtilTest.assertNotNull(_map, (String)"Map is null.");
        if (_keys != null) {
            for (K key : _keys) {
                AbstractBaseUtilTest.assertTrue((boolean)_map.containsKey(key), (String)("Key [" + String.valueOf(key) + "] not found in map: " + String.valueOf(_map)));
            }
        }
        return _map;
    }

    @SafeVarargs
    public static final <V> Collection<V> assertCollection(Collection<V> _coll, V ... _values) {
        AbstractBaseUtilTest.assertNotNull(_coll, (String)"Collection is null.");
        ArrayList<V> notFound = new ArrayList<V>();
        if (_values != null) {
            for (V val : _values) {
                if (_coll.contains(val)) continue;
                notFound.add(val);
            }
        }
        AbstractBaseUtilTest.assertTrue((notFound.size() == 0 ? 1 : 0) != 0, (String)("Values " + String.valueOf(notFound) + " not found in collection: " + String.valueOf(_coll)));
        return _coll;
    }

    public static void assertInstanceOf(Object _obj, Class<?> _class) {
        AbstractBaseUtilTest.assertTrue((_obj != null && _class != null && _class.isAssignableFrom(_obj.getClass()) ? 1 : 0) != 0, (String)(String.valueOf(_obj) + " is not an instance of " + String.valueOf(_class) + "."));
    }

    public static final void assertPatternFind(String _str, String _pattern) {
        AbstractBaseUtilTest.assertNotNull((Object)_str, (String)"String may not be null.");
        AbstractBaseUtilTest.assertNotNull((Object)_pattern, (String)"Pattern may not be null.");
        AbstractBaseUtilTest.assertTrue((boolean)Pattern.compile(_pattern).matcher(_str).find(), (String)("Pattern [" + _pattern + "] not found in string [" + _str + "]."));
    }

    public static final void assertPatternMatches(String _str, String _pattern) {
        AbstractBaseUtilTest.assertNotNull((Object)_str, (String)"String may not be null.");
        AbstractBaseUtilTest.assertNotNull((Object)_pattern, (String)"Pattern may not be null.");
        AbstractBaseUtilTest.assertTrue((boolean)Pattern.compile(_pattern).matcher(_str).matches(), (String)("Pattern [" + _pattern + "] does not match string [" + _str + "]."));
    }
}

