/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.classloader;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.classloader.ClassLoaderWithRegistry;
import com.github.hypfvieh.classloader.ComponentRegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class ClassLoaderWithRegistryTest
extends AbstractBaseUtilTest {
    @Test
    public void testUseClassLoaderWithRegistry() throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        String testClass = "com.github.hypfvieh.classloader.ClassLoaderWithRegistryTest$LoaderTest";
        ClassLoaderWithRegistry classLoaderWithRegistry = new ClassLoaderWithRegistry(Class.forName(testClass).getClassLoader());
        classLoaderWithRegistry.addIncludedPackageNames("com.github.hypfvieh.classloader.");
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoaderWithRegistry);
        ClassLoader cls = Thread.currentThread().getContextClassLoader();
        Class<?> c = cls.loadClass(testClass);
        Object o = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Class[] paramString = new Class[]{List.class};
        c.getMethod("run", paramString).invoke(o, new ArrayList<String>(Arrays.asList("foo", "bar", "baz")));
        for (Map.Entry entry : ComponentRegistry.getInstance().getComponentsVersions().entrySet()) {
            System.out.println("    --> Loaded Class '" + (String)entry.getKey() + "' with version: " + (String)entry.getValue());
        }
        ClassLoaderWithRegistryTest.assertEquals((int)3, (int)ComponentRegistry.getInstance().getComponentsVersions().size());
    }

    public static class LoaderTest {
        private static final String version = "1.0.2-BETA-4";

        public static void run(List<String> args) {
            System.out.println("    --> TestLoader Running!");
            int i = 0;
            for (String arg : args) {
                System.out.println("      --> Argument " + i + ": " + arg);
                ++i;
            }
        }

        public static String getVersion() {
            return version;
        }
    }
}

