/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.config.xml;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.common.SearchOrder;
import com.github.hypfvieh.config.xml.XmlConfigBuilder;
import com.github.hypfvieh.config.xml.XmlConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.junit.jupiter.api.Test;

public class XmlConfigurationTest
extends AbstractBaseUtilTest {
    @Test
    public void testGetString() throws IOException {
        XmlConfiguration xmlConfiguration = new XmlConfigBuilder().setInputFile("src/test/resources/xmlConfigTest/xmlConfigTest.xml", new SearchOrder[0]).build();
        String readValue = xmlConfiguration.getString("Config/Key2/SubKey1");
        XmlConfigurationTest.assertEquals((Object)"SubValue1", (Object)readValue);
        readValue = xmlConfiguration.getString("Config/Key3/SubKeyList/SubListEntry");
        XmlConfigurationTest.assertEquals((Object)"SubListEntry1", (Object)readValue);
        readValue = xmlConfiguration.getString("Not/existing");
        XmlConfigurationTest.assertNull((Object)readValue);
    }

    @Test
    public void testGetList() throws IOException {
        XmlConfiguration xmlConfiguration = new XmlConfigBuilder().setInputFile("src/test/resources/xmlConfigTest/xmlConfigTest.xml", new SearchOrder[0]).build();
        List readValue = xmlConfiguration.getStringList("Config/Key2/SubKey1");
        XmlConfigurationTest.assertEquals((int)1, (int)readValue.size());
        XmlConfigurationTest.assertEquals((Object)"SubValue1", readValue.get(0));
        readValue = null;
        readValue = xmlConfiguration.getStringList("Config/Key3/SubKeyList/SubListEntry");
        XmlConfigurationTest.assertEquals((int)4, (int)readValue.size());
        XmlConfigurationTest.assertEquals((Object)"SubListEntry2", readValue.get(1));
        XmlConfigurationTest.assertEquals((Object)"SubListEntry3", readValue.get(3));
        readValue = null;
        readValue = xmlConfiguration.getStringList("Config/Key3/SubKeyList");
        XmlConfigurationTest.assertEquals((int)4, (int)readValue.size());
        XmlConfigurationTest.assertEquals((Object)"SubListEntry2", readValue.get(1));
        XmlConfigurationTest.assertEquals((Object)"SubListEntry3", readValue.get(3));
    }

    @Test
    public void testSetString() throws IOException {
        XmlConfiguration xmlConfiguration = new XmlConfigBuilder().setInputFile("src/test/resources/xmlConfigTest/xmlConfigTest.xml", new SearchOrder[0]).build();
        String readValue = xmlConfiguration.getString("Config/Key2/SubKey1");
        XmlConfigurationTest.assertEquals((Object)"SubValue1", (Object)readValue);
        xmlConfiguration.setString("Config/Key2/SubKey1", false, "NewValue1");
        readValue = xmlConfiguration.getString("Config/Key2/SubKey1");
        XmlConfigurationTest.assertEquals((Object)"NewValue1", (Object)readValue);
    }

    @Test
    public void testSetValues() throws IOException {
        XmlConfiguration xmlConfiguration = new XmlConfigBuilder().setInputFile("src/test/resources/xmlConfigTest/xmlConfigTest.xml", new SearchOrder[0]).build();
        String readValue = xmlConfiguration.getString("Config/Key2/SubKey1");
        XmlConfigurationTest.assertEquals((Object)"SubValue1", (Object)readValue);
        readValue = xmlConfiguration.getString("Config/Key4/NotInt");
        XmlConfigurationTest.assertEquals((Object)"A", (Object)readValue);
        readValue = xmlConfiguration.getString("Config/Key4/Int");
        XmlConfigurationTest.assertEquals((Object)"100", (Object)readValue);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("Config/Key2/SubKey1", "NewValue1");
        values.put("Config/Key4/NotInt", "B");
        values.put("Config/Key4/Int", "2000");
        xmlConfiguration.setValues(values, false);
        readValue = xmlConfiguration.getString("Config/Key2/SubKey1");
        XmlConfigurationTest.assertEquals((Object)"NewValue1", (Object)readValue);
        readValue = xmlConfiguration.getString("Config/Key4/NotInt");
        XmlConfigurationTest.assertEquals((Object)"B", (Object)readValue);
        readValue = xmlConfiguration.getString("Config/Key4/Int");
        XmlConfigurationTest.assertEquals((Object)"2000", (Object)readValue);
    }

    @Test
    public void testSaveToFile() throws IOException {
        File tempFile = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName() + XmlConfigurationTest.getMethodName(), ".xml");
        XmlConfiguration xmlConfiguration = new XmlConfigBuilder().setInputFile("src/test/resources/xmlConfigTest/xmlConfigTest.xml", new SearchOrder[0]).setOutputFile(tempFile).build();
        String readValue = xmlConfiguration.getString("Config/Key2/SubKey1");
        XmlConfigurationTest.assertEquals((Object)"SubValue1", (Object)readValue);
        xmlConfiguration.setString("Config/Key2/SubKey1", false, "NewValue1");
        readValue = xmlConfiguration.getString("Config/Key2/SubKey1");
        XmlConfigurationTest.assertEquals((Object)"NewValue1", (Object)readValue);
        xmlConfiguration.save();
        xmlConfiguration = null;
        xmlConfiguration = new XmlConfigBuilder().setInputFile(tempFile, new SearchOrder[0]).build();
        readValue = xmlConfiguration.getString("Config/Key2/SubKey1");
        XmlConfigurationTest.assertEquals((Object)"NewValue1", (Object)readValue);
        tempFile.delete();
    }

    @Test
    public void testGetStringProperty() {
        XmlConfiguration xmlConfiguration = new XmlConfigBuilder().setInputFile("src/test/resources/xmlConfigTest/xmlConfigTest.xml", new SearchOrder[0]).setSkipRoot(true).setKeyDelimiter(".").setAllowKeyOverrideFromEnvironment(true).build();
        XmlConfigurationTest.assertEquals((Object)"Value1", (Object)xmlConfiguration.getString("Key1", "Key2"));
        XmlConfigurationTest.assertNotEquals("fail", xmlConfiguration.getString("Key1", "fail"));
        XmlConfigurationTest.assertNotEquals("fail", xmlConfiguration.getString("foo", "bar"));
        XmlConfigurationTest.assertEquals((Object)"fail", (Object)xmlConfiguration.getString("foo", "fail"));
        System.getProperties().setProperty("Key2.SubKey1", "Jambalaja");
        XmlConfigurationTest.assertEquals((Object)"Jambalaja", (Object)xmlConfiguration.getString("Key2.SubKey1", "default"));
    }

    @Test
    public void testGetStringListProperty() {
        XmlConfiguration xmlConfiguration = new XmlConfigBuilder().setInputFile("src/test/resources/xmlConfigTest/xmlConfigTest.xml", new SearchOrder[0]).setSkipRoot(true).setKeyDelimiter(".").build();
        List stringList = xmlConfiguration.getStringList("Key3.SubKeyList.SubListEntry");
        XmlConfigurationTest.assertFalse((boolean)stringList.isEmpty());
        XmlConfigurationTest.assertTrue((stringList.size() == 4 ? 1 : 0) != 0);
        XmlConfigurationTest.assertEquals((Object)"SubListEntry1", stringList.get(0));
    }

    @Test
    public void testGetStringSetProperty() {
        XmlConfiguration xmlConfiguration = new XmlConfigBuilder().setInputFile("src/test/resources/xmlConfigTest/xmlConfigTest.xml", new SearchOrder[0]).setKeyDelimiter(".").setSkipRoot(true).build();
        Set stringList = xmlConfiguration.getStringSet("Key3.SubKeyList.SubListEntry", TreeSet.class);
        XmlConfigurationTest.assertFalse((boolean)stringList.isEmpty());
        XmlConfigurationTest.assertTrue((stringList.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testGetIntProperty() {
        XmlConfiguration xmlConfiguration = new XmlConfigBuilder().setInputFile("src/test/resources/xmlConfigTest/xmlConfigTest.xml", new SearchOrder[0]).setSkipRoot(true).setKeyDelimiter(".").build();
        XmlConfigurationTest.assertEquals((int)-1, (int)xmlConfiguration.getInt("Key4.NotInt", -1));
        XmlConfigurationTest.assertEquals((int)100, (int)xmlConfiguration.getInt("Key4.Int", -1));
    }

    @Test
    public void testGetBooleanProperty() {
        XmlConfiguration xmlConfiguration = new XmlConfigBuilder().setInputFile("src/test/resources/xmlConfigTest/xmlConfigTest.xml", new SearchOrder[0]).setSkipRoot(true).setKeyDelimiter(".").build();
        XmlConfigurationTest.assertEquals((Object)false, (Object)xmlConfiguration.getBoolean("Key5.NotBool", false));
        XmlConfigurationTest.assertEquals((Object)true, (Object)xmlConfiguration.getBoolean("Key5.Bool", false));
    }
}

