/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.util.CollectionUtil;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class CollectionUtilTest
extends AbstractBaseUtilTest {
    @Test
    void testHasValue() {
        CollectionUtilTest.assertTrue((boolean)CollectionUtil.hasValue(List.of(Integer.valueOf(1))));
        CollectionUtilTest.assertTrue((boolean)CollectionUtil.hasValue(Set.of("yes")));
        CollectionUtilTest.assertFalse((boolean)CollectionUtil.hasValue(List.of()));
        CollectionUtilTest.assertFalse((boolean)CollectionUtil.hasValue(Set.of()));
        CollectionUtilTest.assertFalse((boolean)CollectionUtil.hasValue(null));
    }

    @Test
    void testCreateMutableList() {
        List mutableIntList = CollectionUtil.mutableListOf((Object[])new Integer[]{1, 2, 3});
        CollectionUtilTest.assertNotNull((Object)mutableIntList);
        CollectionUtilTest.assertEquals((int)3, (int)mutableIntList.size());
        CollectionUtilTest.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), (Object)mutableIntList);
        CollectionUtilTest.assertDoesNotThrow(() -> mutableIntList.add(4));
        CollectionUtilTest.assertEquals((int)4, (int)mutableIntList.size());
        CollectionUtilTest.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), (Object)mutableIntList);
    }

    @Test
    void testGetFirstOrDefault() {
        CollectionUtilTest.assertEquals((int)1, (Integer)((Integer)CollectionUtil.getFirstOrDefault(List.of(Integer.valueOf(1), Integer.valueOf(2)), null)));
        CollectionUtilTest.assertEquals((Object)"X", (Object)CollectionUtil.getFirstOrDefault(List.of(), (Object)"X"));
        CollectionUtilTest.assertEquals((int)5, (Integer)((Integer)CollectionUtil.getFirstOrDefault(null, (Object)5)));
        CollectionUtilTest.assertNull((Object)CollectionUtil.getFirstOrDefault(List.of(), null));
    }
}

