/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.AbstractBaseUtilTest;
import com.github.hypfvieh.util.TimeMeasure;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class TimeMeasureTest
extends AbstractBaseUtilTest {
    TimeMeasureTest() {
    }

    @Test
    void testTimeMeasure() throws InterruptedException {
        TimeMeasure tm = new TimeMeasure();
        TimeMeasureTest.assertTrue((tm.getElapsedMillis() >= 0L ? 1 : 0) != 0);
        Thread.sleep(100L);
        TimeMeasureTest.assertTrue((tm.getElapsedMillis() >= 100L ? 1 : 0) != 0);
        String str = tm.toString();
        TimeMeasureTest.assertPatternMatches(str, "^[0-9\\.,]+ ms$");
        tm.reset();
        long elapsed = tm.getElapsedMillis();
        TimeMeasureTest.assertTrue((elapsed < 10L ? 1 : 0) != 0);
        tm = new TimeMeasure(System.nanoTime() - TimeUnit.SECONDS.toNanos(10L));
        elapsed = tm.getElapsedMillis();
        TimeMeasureTest.assertTrue((elapsed >= 10000L ? 1 : 0) != 0);
        TimeMeasureTest.assertPatternMatches(tm.toString(), "^[0-9\\.]+ seconds$");
    }

    @Test
    void testGetElapsed() {
        long startNanos = System.nanoTime() - TimeUnit.SECONDS.toNanos(10L);
        TimeMeasure tm = new TimeMeasure(startNanos);
        TimeMeasureTest.assertEquals((long)10L, (long)tm.getElapsedSeconds());
    }

    @Test
    void testGetElapsedMinutes() {
        long startNanos = System.nanoTime() - TimeUnit.MINUTES.toNanos(20L) - TimeUnit.SECONDS.toNanos(15L);
        TimeMeasure tm = new TimeMeasure(startNanos);
        TimeMeasureTest.assertEquals((double)20.25, (double)tm.getElapsedMinutes(), (double)1.0E-8);
    }

    @ParameterizedTest(name="[{index}] {0} -> \"{1}\"")
    @CsvSource(delimiterString=";", value={"-1; '-1,00 ms'", "0; 0,00 ms", "0.165; 0,17 ms", "0.5; 0,50 ms", "1000; 1000 ms", "1001; 1001 ms", "3721; 3721 ms", "4999; 4999 ms", "5000; 5000 ms", "5001; 5001 ms", "61000; 61 seconds", "180000; 180 seconds", "3600000; 01:00:00"})
    void testFormatDuration(double _elapsed, String _expected) {
        TimeMeasureTest.assertEquals((Object)_expected, (Object)TimeMeasure.formatDuration((double)_elapsed, (Locale)Locale.GERMAN));
    }
}

