/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.db;

import com.github.hypfvieh.db.DbConnParms;
import com.github.hypfvieh.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class H2ConnParms
extends DbConnParms {
    private final String dbPath;
    private final List<String> additionalUrlArgs = new ArrayList<String>();

    public H2ConnParms(String _dbFile, String _user, String _password) {
        super("jdbc:h2:" + (StringUtil.endsWithAny(false, _dbFile, ".mv.db", ".h2.db") ? new File(_dbFile).getAbsolutePath().replaceAll("\\.(?:mv|h2)\\.db$", "") : _dbFile), _user, _password, "org.h2.Driver");
        this.dbPath = _dbFile;
    }

    public H2ConnParms(String _dbPath) {
        this(_dbPath, "sa", "");
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public void addAdditionalUrlArgs(String ... _args) {
        if (_args == null) {
            return;
        }
        for (String arg : _args) {
            this.additionalUrlArgs.add(arg);
        }
    }

    public void removeAdditionalUrlArgs(String ... _args) {
        if (_args == null) {
            return;
        }
        for (String arg : _args) {
            this.additionalUrlArgs.remove(arg);
        }
    }

    public List<String> getAdditionalUrlArgs() {
        return Collections.unmodifiableList(this.additionalUrlArgs);
    }

    @Override
    public String getUrl() {
        if (this.additionalUrlArgs.isEmpty()) {
            return super.getUrl();
        }
        return super.getUrl() + ";" + String.join((CharSequence)";", this.additionalUrlArgs);
    }
}

