/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.db;

import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.SystemUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public final class H2Updater {
    private final H2UpdaterBuilder bldr;
    private final File baseTempDir;
    private final List<File> tempFiles = new ArrayList<File>();

    private H2Updater(H2UpdaterBuilder _bldr) {
        this.bldr = _bldr;
        this.baseTempDir = new File(SystemUtil.getTempDir(), this.getClass().getSimpleName());
        if (!this.baseTempDir.exists()) {
            if (!this.baseTempDir.mkdirs()) {
                throw new RuntimeException("Cannot create temp output directory");
            }
            this.baseTempDir.deleteOnExit();
        }
    }

    public void convert(String _dbUsername, String _dbPassword) throws H2UpdaterException {
        String dbUser = Optional.ofNullable(_dbUsername).map(String::trim).filter(s -> !s.isEmpty()).orElse(null);
        String dbPass = Optional.ofNullable(_dbPassword).map(String::trim).filter(s -> !s.isEmpty()).orElse(null);
        String exportPw = StringUtil.randomString(32);
        try {
            File dumpFile = this.exportDatabase(dbUser, dbPass, exportPw);
            this.importDatabase(dbUser, dbPass, exportPw, dumpFile);
        }
        catch (H2UpdaterException _ex) {
            throw _ex;
        }
        finally {
            this.cleanupTemp();
        }
    }

    private void importDatabase(String _dbUsername, String _dbPassword, String _exportPw, File _dumpFile) throws H2UpdaterException {
        try {
            Class<?> importH2Driver = Class.forName("org.h2.Driver", true, this.bldr.getOutputH2Classloader());
            String importQry = "RUNSCRIPT FROM '" + _dumpFile.getAbsolutePath() + "' COMPRESSION LZF CIPHER AES PASSWORD '" + _exportPw + "'";
            if (this.bldr.importExportCharset != null) {
                importQry = importQry + " CHARSET '" + this.bldr.importExportCharset + "'";
            }
            if (!this.bldr.importOptions.isEmpty()) {
                importQry = importQry + " " + this.bldr.importOptions.stream().map(Objects::toString).collect(Collectors.joining(" "));
            }
            String dbUrl = this.createDbUrl(this.bldr.outputFileName);
            try (Connection importConnection = H2Updater.createConnection(importH2Driver, dbUrl, _dbUsername, _dbPassword);
                 Statement importStatement = importConnection.createStatement();){
                importStatement.execute(importQry);
            }
        }
        catch (Exception _ex) {
            throw new H2UpdaterException("Unable to import data to new database", _ex);
        }
    }

    private File exportDatabase(String _dbUsername, String _dbPassword, String _exportPw) throws H2UpdaterException {
        Object exportQry = "SCRIPT";
        if (!this.bldr.exportOptions.isEmpty()) {
            exportQry = (String)exportQry + " " + this.bldr.exportOptions.stream().map(Objects::toString).collect(Collectors.joining(" "));
        }
        try {
            File exportTmpFile = this.createTempFile(this.getClass().getSimpleName(), "export.sql");
            exportQry = (String)exportQry + " TO '" + exportTmpFile.getAbsolutePath() + "'COMPRESSION LZF CIPHER AES PASSWORD '" + _exportPw + "'";
            if (this.bldr.importExportCharset != null) {
                exportQry = (String)exportQry + " CHARSET '" + this.bldr.importExportCharset + "'";
            }
            Class<?> h2Driver = Class.forName("org.h2.Driver", true, this.bldr.getInputH2ClassLoader());
            File tempFile = this.createTempFile(this.getClass().getSimpleName() + "-tmpdb", ".mv.db");
            Files.copy(this.bldr.getInputFile().toPath(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            try (Connection exportConnection = H2Updater.createConnection(h2Driver, this.createDbUrl(tempFile.getAbsolutePath()), _dbUsername, _dbPassword);
                 Statement exportStatement = exportConnection.createStatement();){
                exportStatement.execute((String)exportQry);
            }
            return exportTmpFile;
        }
        catch (Exception _ex) {
            throw new H2UpdaterException("Unable to export old database", _ex);
        }
    }

    private File createTempFile(String _prefix, String _suffix) {
        long nano = System.nanoTime();
        if (nano <= 0L) {
            Random random = new Random();
            nano = System.currentTimeMillis() + (long)random.nextInt();
        }
        File file = new File(this.baseTempDir, _prefix + "_" + nano + _suffix);
        file.deleteOnExit();
        this.tempFiles.add(file);
        return file;
    }

    private String createDbUrl(String _dbFile) {
        if (_dbFile == null) {
            return null;
        }
        String url = "jdbc:h2:" + _dbFile.replaceFirst("\\.mv\\.db$", "");
        if (!this.bldr.getH2OpenOptions().isEmpty()) {
            url = url + ";" + this.bldr.h2OpenOptions.entrySet().stream().filter(e -> !((String)e.getKey()).equals("ACCESS_MODE_DATA")).filter(e -> !((String)e.getKey()).equals("AUTO_SERVER")).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(";"));
        }
        return url;
    }

    private static Connection createConnection(Class<?> _h2Driver, String _url, String _user, String _password) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, SQLException {
        if (Driver.class.isAssignableFrom(_h2Driver)) {
            Driver driverInstance = (Driver)_h2Driver.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LoggerFactory.getLogger(H2Updater.class).debug("Loaded class {} with version info {}.{}", new Object[]{_h2Driver, driverInstance.getMajorVersion(), driverInstance.getMinorVersion()});
            Properties prop = new Properties();
            if (_user != null) {
                prop.setProperty("user", _user);
            }
            if (_password != null) {
                prop.setProperty("password", _password);
            }
            return driverInstance.connect(_url, prop);
        }
        throw new RuntimeException("Given driver " + String.valueOf(_h2Driver) + " is not a java.sql.Driver");
    }

    private void cleanupTemp() {
        Collections.sort(this.tempFiles);
        this.tempFiles.removeIf(f -> {
            if (f.isDirectory()) {
                return false;
            }
            return f.delete();
        });
        for (File file : this.tempFiles) {
            file.delete();
        }
        this.tempFiles.clear();
    }

    public static class H2UpdaterBuilder {
        private ClassLoader inputH2ClassLoader;
        private ClassLoader outputH2Classloader;
        private File inputFile;
        private String outputFileName;
        private String importExportCharset;
        private Map<String, String> h2OpenOptions = new LinkedHashMap<String, String>();
        private final Set<ExportOption> exportOptions = new LinkedHashSet<ExportOption>();
        private final Set<ImportOption> importOptions = new LinkedHashSet<ImportOption>();

        private H2UpdaterBuilder(ClassLoader _inputClzLdr, ClassLoader _outputClzLdr) {
            this.inputH2ClassLoader = _inputClzLdr;
            this.outputH2Classloader = _outputClzLdr;
        }

        ClassLoader getInputH2ClassLoader() {
            return this.inputH2ClassLoader;
        }

        ClassLoader getOutputH2Classloader() {
            return this.outputH2Classloader;
        }

        String getOutputFileName() {
            return this.outputFileName;
        }

        File getInputFile() {
            return this.inputFile;
        }

        Map<String, String> getH2OpenOptions() {
            return this.h2OpenOptions;
        }

        public H2UpdaterBuilder withH2OpenOptions(Map<String, String> _options) {
            if (_options == null) {
                this.h2OpenOptions.clear();
                return this;
            }
            this.h2OpenOptions.putAll(_options);
            return this;
        }

        public H2UpdaterBuilder withInputFile(File _h2InputFile) throws H2UpdaterException {
            if (_h2InputFile == null || !_h2InputFile.exists()) {
                throw new H2UpdaterException("Database file cannot be null and must exist");
            }
            this.inputFile = _h2InputFile;
            return this;
        }

        public H2UpdaterBuilder withOutputFileName(String _outputFileName) throws H2UpdaterException {
            if (_outputFileName == null || _outputFileName.isBlank()) {
                throw new H2UpdaterException("Output database file name cannot be null or blank");
            }
            File checkFile = new File((String)(_outputFileName.endsWith(".mv.db") ? _outputFileName : _outputFileName + ".mv.db"));
            if (checkFile.exists()) {
                throw new H2UpdaterException("Output database must not exist");
            }
            this.outputFileName = checkFile.getAbsolutePath().replaceFirst("\\.mv\\.db$", "");
            return this;
        }

        public H2UpdaterBuilder withImportExportCharset(Charset _charset) {
            this.importExportCharset = _charset == null ? null : _charset.name();
            return this;
        }

        public H2UpdaterBuilder addExportOption(ExportOption _opt) throws H2UpdaterException {
            if (_opt == null) {
                return this;
            }
            if (_opt == ExportOption.NODATA && this.exportOptions.contains((Object)ExportOption.SIMPLE) || this.exportOptions.contains((Object)ExportOption.COLUMNS)) {
                throw new H2UpdaterException("NODATA option cannot be used in combination with SIMPLE or COLUMNS option");
            }
            if (_opt == ExportOption.SIMPLE || _opt == ExportOption.COLUMNS && this.exportOptions.contains((Object)ExportOption.NODATA)) {
                throw new H2UpdaterException("SIMPLE or COLUMNS option cannot be used in combination NODATA option");
            }
            this.exportOptions.add(_opt);
            return this;
        }

        public H2UpdaterBuilder addRemoveExportOption(ExportOption _opt) {
            this.exportOptions.remove((Object)_opt);
            return this;
        }

        public H2UpdaterBuilder addImportOption(ImportOption _opt) throws H2UpdaterException {
            if (_opt == null) {
                return this;
            }
            if (_opt == ImportOption.FROM_1X && this.importOptions.contains((Object)ImportOption.QUIRKS_MODE) || this.importOptions.contains((Object)ImportOption.VARIABLE_BINARY)) {
                throw new H2UpdaterException("FROM_1X option cannot be used in combination with QUIRKS_MODE or VARIABLE_BINARY option");
            }
            if (_opt == ImportOption.QUIRKS_MODE || _opt == ImportOption.VARIABLE_BINARY && this.importOptions.contains((Object)ImportOption.FROM_1X)) {
                throw new H2UpdaterException("QUIRKS_MODE or VARIABLE_BINARY option cannot be used in combination FROM_1X option");
            }
            this.importOptions.add(_opt);
            return this;
        }

        public H2UpdaterBuilder addRemoveImportOption(ImportOption _opt) {
            this.importOptions.remove((Object)_opt);
            return this;
        }

        public H2Updater build() throws H2UpdaterException {
            if (this.inputFile == null) {
                throw new H2UpdaterException("Setup inputFile using withInputFile() first");
            }
            if (this.outputFileName == null) {
                throw new H2UpdaterException("Setup outputFileName using withOutputFileName() first");
            }
            return new H2Updater(this);
        }

        public static H2UpdaterBuilder create(File _inputH2Jar, File _outputH2Jar) throws H2UpdaterException {
            return new H2UpdaterBuilder(H2UpdaterBuilder.loadJar(_inputH2Jar), H2UpdaterBuilder.loadJar(_outputH2Jar));
        }

        private static ClassLoader loadJar(File _h2Jar) throws H2UpdaterException {
            if (_h2Jar == null || !_h2Jar.exists() || !_h2Jar.canRead()) {
                throw new H2UpdaterException("Given H2 jar " + String.valueOf(_h2Jar) + " does not exist or cannot be read");
            }
            try {
                return new URLClassLoader(new URL[]{_h2Jar.toURI().toURL()}, ClassLoader.getPlatformClassLoader());
            }
            catch (MalformedURLException _ex) {
                throw new H2UpdaterException("Unable to convert file path to URL", _ex);
            }
        }
    }

    public static class H2UpdaterException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public H2UpdaterException(String _message, Throwable _cause) {
            super(_message, _cause);
        }

        public H2UpdaterException(String _message) {
            super(_message);
        }
    }

    public static enum ImportOption {
        QUIRKS_MODE,
        VARIABLE_BINARY,
        FROM_1X;

    }

    public static enum ExportOption {
        NODATA,
        SIMPLE,
        COLUMNS,
        NOPASSWORDS,
        NOSETTINGS,
        DROP;

    }
}

