/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.db;

import com.github.hypfvieh.util.TypeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;

public class H2Util {
    private static final byte[] MAGIC_XSET = new byte[]{38, 88, 83, 69, 84};
    private static final byte[] MAGIC_BUILD_NUMBER = new byte[]{32, 67, 82, 69, 65, 84, 69, 95, 66, 85, 73, 76, 68, 32};
    private static final byte[] MAGIC_FORMAT = new byte[]{44, 102, 111, 114, 109, 97, 116, 58};

    public static H2VersionInfo findH2Version(InputStream _input) throws IOException {
        byte[] buf = new byte[2048];
        String buildNumber = null;
        String formatNumber = null;
        try (InputStream fis = _input;){
            int pos = -1;
            boolean foundXset = false;
            while (fis.read(buf) > 0) {
                if (!foundXset) {
                    boolean bl = foundXset = H2Util.byteScan(buf, MAGIC_XSET) > -1;
                }
                if (buildNumber == null && foundXset && (pos = H2Util.byteScan(buf, MAGIC_BUILD_NUMBER)) > -1) {
                    buildNumber = H2Util.findNumbers(buf, pos, 3);
                }
                if (formatNumber == null && (pos = TypeUtil.indexOfByteArray(buf, MAGIC_FORMAT)) > -1) {
                    int searchPos = pos + MAGIC_FORMAT.length;
                    formatNumber = new String(Arrays.copyOfRange(buf, searchPos, searchPos + 1));
                }
                if (buildNumber == null || formatNumber == null) continue;
                break;
            }
        }
        if (!TypeUtil.isInteger(formatNumber) || !TypeUtil.isInteger(buildNumber)) {
            return null;
        }
        return new H2VersionInfo(Integer.valueOf(buildNumber), Integer.valueOf(formatNumber));
    }

    static String findNumbers(byte[] _buf, int _offset, int _amountOfNumbers) {
        if (_buf.length < _offset || _buf.length < _amountOfNumbers) {
            return null;
        }
        ByteBuffer bucket = ByteBuffer.allocate(_amountOfNumbers);
        int bytesRead = 0;
        for (int i = _offset; i < _buf.length; ++i) {
            if (_buf[i] >= 48 && _buf[i] <= 57) {
                bucket.put(_buf[i]);
                ++bytesRead;
            }
            if (bytesRead < _amountOfNumbers) continue;
            return new String(bucket.array());
        }
        return null;
    }

    static int byteScan(byte[] _heystack, byte[] _needle) {
        ByteBuffer bucket = ByteBuffer.allocate(_needle.length);
        boolean foundFirst = false;
        int bytesRead = 0;
        for (int i = 0; i < _heystack.length; ++i) {
            if (!foundFirst && _heystack[i] == _needle[0]) {
                foundFirst = true;
            }
            if (foundFirst && _heystack[i] >= 32 && _heystack[i] <= 126) {
                bucket.put(_heystack[i]);
                ++bytesRead;
            }
            if (bytesRead < _needle.length) continue;
            if (TypeUtil.indexOfByteArray(bucket.array(), _needle) > -1) {
                return i;
            }
            byte[] current = new byte[bucket.array().length - 1];
            System.arraycopy(bucket.array(), 1, current, 0, bucket.array().length - 1);
            bucket.rewind();
            bucket.put(current);
            bytesRead = bucket.array().length - 1;
        }
        return -1;
    }

    public static class H2VersionInfo
    implements Comparable<H2VersionInfo> {
        private final int build;
        private final int format;

        public H2VersionInfo(Integer _build, Integer _format) {
            this.build = _build;
            this.format = _format;
        }

        public int getBuild() {
            return this.build;
        }

        public int getFormat() {
            return this.format;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [build=" + this.build + ", format=" + this.format + "]";
        }

        public int hashCode() {
            return Objects.hash(this.build, this.format);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            H2VersionInfo other = (H2VersionInfo)obj;
            return this.build == other.build && this.format == other.format;
        }

        @Override
        public int compareTo(H2VersionInfo _o) {
            if (_o == null) {
                return -1;
            }
            if (_o.getBuild() == this.getBuild() && _o.getFormat() == this.getFormat()) {
                return 0;
            }
            if (_o.getBuild() > this.getBuild()) {
                return -1;
            }
            if (_o.getFormat() > this.getFormat()) {
                return -1;
            }
            return 1;
        }
    }
}

