/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.db.persistence;

import com.github.hypfvieh.db.persistence.DriverType;
import com.github.hypfvieh.db.persistence.JpaEnhancedClassLoader;
import com.github.hypfvieh.util.StringUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractBasePersistenceLoader<T extends AbstractBasePersistenceLoader<T>> {
    private final DriverType driverType;
    private PersistenceLoaderContext context;
    private String dbUrl;
    private String dbUser;
    private String dbPass;
    private String jdbcDriver;
    private String persistenceUnitName;
    private Map<String, String> additionalDbProps;
    private final Class<T> self;

    AbstractBasePersistenceLoader(DriverType _driverType, Class<T> _self) {
        this.self = _self;
        this.driverType = Objects.requireNonNull(_driverType);
        this.jdbcDriver = _driverType.getDriverClassName();
    }

    protected T self() {
        return (T)((AbstractBasePersistenceLoader)this.self.cast(this));
    }

    public T withDbUrl(String _dbUrl) {
        Objects.requireNonNull(_dbUrl, "dbUrl must not be null");
        if (this.driverType == DriverType.GENERIC && !_dbUrl.startsWith("jdbc:")) {
            throw new IllegalArgumentException("dbUrl must start with 'jdbc:' when using GENERIC driver type");
        }
        if (this.driverType != DriverType.GENERIC && _dbUrl.startsWith("jdbc:")) {
            throw new IllegalArgumentException("dbUrl must not start with 'jdbc:' when using non-GENERIC driver type");
        }
        this.dbUrl = _dbUrl;
        return this.self();
    }

    public T withDbUser(String _dbUser) {
        this.dbUser = _dbUser;
        return this.self();
    }

    public T withDbPass(String _dbPass) {
        this.dbPass = _dbPass;
        return this.self();
    }

    public T withJdbcDriver(String _jdbcDriver) {
        this.jdbcDriver = Objects.requireNonNull(_jdbcDriver, "jdbcDriver must not be null");
        return this.self();
    }

    public T withPersistenceUnitName(String _persistenceUnitName) {
        this.persistenceUnitName = _persistenceUnitName;
        return this.self();
    }

    public T withAdditionalDbProps(Map<String, String> _additionalDbProps) {
        this.additionalDbProps = _additionalDbProps;
        return this.self();
    }

    public PersistenceLoaderContext build() {
        if (this.context == null) {
            this.context = new PersistenceLoaderContext(this);
        }
        return this.context;
    }

    protected abstract byte[] createPersistenceXml() throws IOException;

    protected String getDbUser() {
        return this.dbUser;
    }

    protected String getDbPass() {
        return this.dbPass;
    }

    protected String getJdbcDriver() {
        return this.jdbcDriver;
    }

    protected DriverType getDriverType() {
        return this.driverType;
    }

    protected String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    protected Map<String, String> getAdditionalDbProps() {
        return this.additionalDbProps;
    }

    protected String getDbUrl() {
        return this.dbUrl;
    }

    public static final class PersistenceLoaderContext
    implements Closeable {
        private final Set<EntityManager> entityManagers = new HashSet<EntityManager>();
        private final AbstractBasePersistenceLoader<?> loader;
        private EntityManagerFactory entityManagerFactory;

        PersistenceLoaderContext(AbstractBasePersistenceLoader<?> _loader) {
            StringUtil.requireNonBlank(_loader.getPersistenceUnitName(), "PersistenceUnitName required");
            StringUtil.requireNonBlank(_loader.getDbUrl(), "Database URL required");
            this.loader = _loader;
        }

        public EntityManager createEntityManager() throws IOException {
            if (this.entityManagerFactory == null) {
                this.entityManagerFactory = this.createEntityManagerFactory();
            }
            EntityManager entityManager = this.entityManagerFactory.createEntityManager();
            this.entityManagers.add(entityManager);
            return entityManager;
        }

        public EntityManager getOrCreateEntityManager() throws IOException {
            if (this.entityManagers.isEmpty()) {
                return this.createEntityManager();
            }
            this.entityManagers.removeIf(em -> !em.isOpen());
            return this.entityManagers.stream().filter(EntityManager::isOpen).findFirst().orElse(this.createEntityManager());
        }

        public EntityManagerFactory createEntityManagerFactory() throws IOException {
            if (this.entityManagerFactory != null) {
                return this.entityManagerFactory;
            }
            byte[] inMemoryData = this.loader.createPersistenceXml();
            JpaEnhancedClassLoader myClassLoader = new JpaEnhancedClassLoader(this.getClass().getClassLoader(), inMemoryData);
            Thread.currentThread().setContextClassLoader(myClassLoader);
            String url = String.format(this.loader.getDriverType().getUrlTemplate(), this.loader.getDbUrl());
            HashMap<String, String> properties = new HashMap<String, String>();
            if (this.loader.getAdditionalDbProps() != null) {
                properties.putAll(this.loader.getAdditionalDbProps());
            }
            properties.put("jakarta.persistence.jdbc.url", url);
            properties.put("jakarta.persistence.jdbc.driver", this.loader.getJdbcDriver());
            properties.put("jakarta.persistence.jdbc.user", StringUtil.trimToEmpty(this.loader.getDbUser()));
            properties.put("jakarta.persistence.jdbc.password", StringUtil.trimToEmpty(this.loader.getDbPass()));
            return Persistence.createEntityManagerFactory((String)this.loader.getPersistenceUnitName(), properties);
        }

        @Override
        public void close() {
            if (!this.entityManagers.isEmpty()) {
                this.entityManagers.forEach(EntityManager::close);
                this.entityManagers.clear();
            }
            if (this.entityManagerFactory != null) {
                this.entityManagerFactory.close();
                this.entityManagerFactory = null;
            }
        }
    }

    public static enum PersistenceXmlRootProp {
        XMLNS("xmlns", "https://jakarta.ee/xml/ns/persistence"),
        XMLNS_XSI("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"),
        XSI_SCHEMALOCATION("xsi:schemaLocation", "https://jakarta.ee/xml/ns/persistence https://jakarta.ee/xml/ns/persistence/persistence_3_0.xsd"),
        VERSION("version", "3.0");

        private final String keyName;
        private final String defaultValue;

        private PersistenceXmlRootProp(String _keyName, String _defaultValue) {
            this.keyName = _keyName;
            this.defaultValue = _defaultValue;
        }

        String getKeyName() {
            return this.keyName;
        }

        String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

