/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.db.persistence;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;

public class JpaEnhancedClassLoader
extends ClassLoader {
    public static final String PERSISTENCE_XML = "META-INF/persistence.xml";
    private final String alternativePersistenceXmlPath;
    private final PersistenceXmlInMemoryStreamHandler inMemHandler;

    public JpaEnhancedClassLoader(ClassLoader _parent, String _alternativePersistenceXmlPath) {
        super(_parent);
        this.alternativePersistenceXmlPath = Objects.requireNonNull(_alternativePersistenceXmlPath);
        this.inMemHandler = null;
    }

    public JpaEnhancedClassLoader(ClassLoader _parent, byte[] _inMemoryData) {
        super(_parent);
        this.alternativePersistenceXmlPath = null;
        this.inMemHandler = new PersistenceXmlInMemoryStreamHandler(_inMemoryData);
    }

    @Override
    public URL getResource(String name) {
        if (name.endsWith(PERSISTENCE_XML)) {
            try {
                if (this.alternativePersistenceXmlPath != null) {
                    return new File(this.alternativePersistenceXmlPath).toURI().toURL();
                }
                return this.createUrl();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return super.getResource(name);
    }

    private URL createUrl() throws MalformedURLException {
        return new URL("persistence-mem", "", -1, PERSISTENCE_XML, this.inMemHandler);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (name.endsWith(PERSISTENCE_XML)) {
            if (this.alternativePersistenceXmlPath != null) {
                return Collections.enumeration(List.of(new File(this.alternativePersistenceXmlPath).toURI().toURL()));
            }
            return Collections.enumeration(List.of(this.createUrl()));
        }
        return super.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (name.endsWith(PERSISTENCE_XML)) {
            try {
                if (this.alternativePersistenceXmlPath != null) {
                    return new FileInputStream(this.alternativePersistenceXmlPath);
                }
                return new ByteArrayInputStream(this.inMemHandler.inMemoryData);
            }
            catch (IOException e) {
                return null;
            }
        }
        return super.getResourceAsStream(name);
    }

    private class PersistenceXmlInMemoryStreamHandler
    extends URLStreamHandler {
        private static final String PROTOCOL = "persistence-mem";
        private byte[] inMemoryData;

        public PersistenceXmlInMemoryStreamHandler(byte[] _inMemoryData) {
            this.inMemoryData = _inMemoryData;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            if (!u.getProtocol().equals(PROTOCOL)) {
                throw new IOException(u.getProtocol() + " not supported");
            }
            return new URLConnection(u){
                private byte[] data;
                {
                    this.data = null;
                }

                @Override
                public void connect() throws IOException {
                    this.connected = true;
                }

                @Override
                public long getContentLengthLong() {
                    return PersistenceXmlInMemoryStreamHandler.this.inMemoryData.length;
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(this.data);
                }
            };
        }
    }
}

