/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.db.persistence;

import com.github.hypfvieh.db.persistence.AbstractBasePersistenceLoader;
import com.github.hypfvieh.db.persistence.DriverType;
import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PersistenceLoader
extends AbstractBasePersistenceLoader<PersistenceLoader> {
    private final Map<AbstractBasePersistenceLoader.PersistenceXmlRootProp, String> persistenceXmlRootProps;
    private final Map<String, List<String>> additionalPersistenceXmlElements = new LinkedHashMap<String, List<String>>();
    private final Map<String, String> additionalPersistenceXmlProperties;
    private String persistenceXmlProvider;

    private PersistenceLoader(DriverType _driverType) {
        super(_driverType, PersistenceLoader.class);
        this.persistenceXmlRootProps = new LinkedHashMap<AbstractBasePersistenceLoader.PersistenceXmlRootProp, String>();
        this.additionalPersistenceXmlProperties = new LinkedHashMap<String, String>();
    }

    public static PersistenceLoader ofType(DriverType _type) {
        return new PersistenceLoader(_type);
    }

    public PersistenceLoader withPersistenceXmlRootProp(AbstractBasePersistenceLoader.PersistenceXmlRootProp _prop, String _value) {
        if (_prop == null) {
            return (PersistenceLoader)this.self();
        }
        if (_value == null) {
            this.persistenceXmlRootProps.remove((Object)_prop);
        } else {
            this.persistenceXmlRootProps.put(_prop, _value);
        }
        return (PersistenceLoader)this.self();
    }

    public PersistenceLoader withPersistenceXmlUnitProperty(String _key, String _value) {
        if (_key == null) {
            return (PersistenceLoader)this.self();
        }
        if (_value == null) {
            this.additionalPersistenceXmlProperties.remove(_key);
        } else {
            this.additionalPersistenceXmlProperties.put(_key, _value);
        }
        return (PersistenceLoader)this.self();
    }

    public PersistenceLoader withPersistenceXmlUnitElement(String _key, List<String> _value) {
        if (_key == null) {
            return (PersistenceLoader)this.self();
        }
        if (_value == null) {
            this.additionalPersistenceXmlElements.remove(_key);
        } else if (this.additionalPersistenceXmlElements.containsKey(_key)) {
            this.additionalPersistenceXmlElements.get(_key).addAll(_value);
        } else {
            this.additionalPersistenceXmlElements.put(_key, new ArrayList<String>(_value));
        }
        return (PersistenceLoader)this.self();
    }

    public PersistenceLoader withPersistenceXmlProvider(String _provider) {
        this.persistenceXmlProvider = _provider;
        return (PersistenceLoader)this.self();
    }

    @Override
    protected byte[] createPersistenceXml() throws IOException {
        DocumentBuilder docBuilder;
        StringUtil.requireNonBlank(this.getPersistenceUnitName(), "PersistenceUnitName required");
        StringUtil.requireNonBlank(this.persistenceXmlProvider, "PersistenceProvider required");
        DocumentBuilderFactory docFacBuilder = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = docFacBuilder.newDocumentBuilder();
        }
        catch (ParserConfigurationException _ex) {
            throw new IOException("Error creating XML parser", _ex);
        }
        Document doc = docBuilder.newDocument();
        doc.setXmlStandalone(true);
        doc.setXmlVersion("1.0");
        Element rootElem = doc.createElement("persistence");
        Arrays.stream(AbstractBasePersistenceLoader.PersistenceXmlRootProp.values()).forEach(k -> {
            String val = this.persistenceXmlRootProps.get(k);
            rootElem.setAttribute(k.getKeyName(), val == null ? k.getDefaultValue() : val);
        });
        Element persistenceUnit = doc.createElement("persistence-unit");
        persistenceUnit.setAttribute("name", this.getPersistenceUnitName());
        rootElem.appendChild(persistenceUnit);
        Element providerElem = doc.createElement("provider");
        providerElem.setTextContent(this.persistenceXmlProvider);
        persistenceUnit.appendChild(providerElem);
        if (!this.additionalPersistenceXmlElements.isEmpty()) {
            this.additionalPersistenceXmlElements.forEach((k, v) -> v.forEach(e -> {
                Element element = doc.createElement((String)k);
                element.setTextContent((String)e);
                persistenceUnit.appendChild(element);
            }));
        }
        if (!this.additionalPersistenceXmlProperties.isEmpty()) {
            Element propertiesElem = doc.createElement("properties");
            persistenceUnit.appendChild(propertiesElem);
            this.additionalPersistenceXmlProperties.forEach((k, v) -> {
                Element element = doc.createElement("property");
                element.setAttribute("name", (String)k);
                element.setAttribute("value", (String)v);
                propertiesElem.appendChild(element);
            });
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XmlUtil.printDocument(doc, baos);
        return baos.toByteArray();
    }
}

