/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.db.persistence;

import com.github.hypfvieh.db.persistence.AbstractBasePersistenceLoader;
import com.github.hypfvieh.db.persistence.DriverType;
import com.github.hypfvieh.util.StringUtil;
import com.github.hypfvieh.util.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class UnitTestPersistenceLoader
extends AbstractBasePersistenceLoader<UnitTestPersistenceLoader> {
    private static final String DEFAULT_PERSISTENCE_UNIT = "UnitTest";
    private static final String FILE_PREFIX = "persistence-";
    private static final String FILE_SUFFIX = ".xml";
    private static final Map<String, String> DEFAULT_DB_SETTINGS = Map.of("jakarta.persistence.schema-generation.database.action", "none", "hibernate.mapping.ignore_not_found", "true", "hibernate.hbm2ddl.skip_foreign_keys", "true", "hibernate.cache.use_second_level_cache", "false", "hibernate.cache.use_query_cache", "false", "hibernate.enable_lazy_load_no_trans", "true", "hibernate.integration.envers.enabled", "false");

    private UnitTestPersistenceLoader(DriverType driverType) {
        super(driverType, UnitTestPersistenceLoader.class);
        this.getAdditionalDbProps().putAll(DEFAULT_DB_SETTINGS);
    }

    public static UnitTestPersistenceLoader ofType(DriverType type) {
        return new UnitTestPersistenceLoader(type);
    }

    @Override
    protected byte[] createPersistenceXml() throws IOException {
        byte[] byArray;
        block12: {
            InputStream persistenceXmlStream = this.getClass().getResourceAsStream("/META-INF/persistence.xml");
            try {
                if (persistenceXmlStream == null) {
                    throw new IllegalStateException("persistence.xml not found in classpath");
                }
                String persistenceXmlFileName = FILE_PREFIX + StringUtil.randomString("META-INF/persistence.xml".length() - FILE_PREFIX.length() - FILE_SUFFIX.length());
                File fileName = new File(System.getProperty("java.io.tmpdir"), persistenceXmlFileName);
                fileName.deleteOnExit();
                DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
                dbFac.setNamespaceAware(false);
                dbFac.setValidating(false);
                Document document = dbFac.newDocumentBuilder().parse(persistenceXmlStream);
                NodeList childNodes = document.getChildNodes().item(0).getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    NodeList properties;
                    Element elm;
                    if (!(childNodes.item(i) instanceof Element) || !(elm = (Element)childNodes.item(i)).getNodeName().equals("persistence-unit")) continue;
                    NodeList jtaDataSources = elm.getElementsByTagName("jta-data-source");
                    if (jtaDataSources.getLength() > 0) {
                        elm.removeChild(jtaDataSources.item(0));
                    }
                    if ((properties = elm.getElementsByTagName("properties")).getLength() > 0) {
                        elm.removeChild(properties.item(0));
                    }
                    elm.setAttribute("name", StringUtil.defaultIfBlank(this.getPersistenceUnitName(), DEFAULT_PERSISTENCE_UNIT));
                    break;
                }
                ByteArrayOutputStream boas = new ByteArrayOutputStream();
                XmlUtil.printDocument(document, boas);
                byArray = boas.toByteArray();
                if (persistenceXmlStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (persistenceXmlStream != null) {
                        try {
                            persistenceXmlStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new IOException("Error while preconfiguring persistence.xml", e);
                }
            }
            persistenceXmlStream.close();
        }
        return byArray;
    }
}

